/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JPanel;
import ro.genomeartist.components.propertiespanel.AbstractPropertiesPanelModel;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.propertiespanel.IPropertiesHeader;
import ro.genomeartist.components.propertiespanel.JPropertiesPanel;
import ro.genomeartist.components.propertiespanel.editors.JCheckBoxPropertiesEditor;
import ro.genomeartist.components.propertiespanel.editors.JSliderPropertiesEditor;
import ro.genomeartist.components.propertiespanel.editors.JTextFieldPropertiesEditor;
import ro.genomeartist.components.propertiespanel.headers.JLabelPropertiesHeader;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.AlgorithmParams;

public class JAlgorithmParametersPane
extends JPanel {
    private AlgorithmParams algorithmParams;
    JPropertiesPanel propertiesPanel;
    MyPropertiesModel propertiesPanelModel;
    Component leftSpacerPanel;
    Component rightSpacerPanel;

    public JAlgorithmParametersPane(AlgorithmParams algorithmParams) {
        this.algorithmParams = algorithmParams;
        this.setLayout(new BorderLayout());
        this.propertiesPanelModel = new MyPropertiesModel();
        this.propertiesPanel = new JPropertiesPanel((AbstractPropertiesPanelModel)this.propertiesPanelModel);
        this.leftSpacerPanel = Box.createHorizontalStrut(50);
        this.rightSpacerPanel = Box.createHorizontalStrut(50);
        this.add(this.leftSpacerPanel, "West");
        this.add((Component)this.propertiesPanel, "Center");
        this.add(this.rightSpacerPanel, "East");
    }

    public boolean commitChanges() {
        boolean hadChanged = this.propertiesPanel.commitChanges();
        if (hadChanged) {
            this.algorithmParams.saveToFile();
            try {
                ExternalLink.getExpansionGenerationCallable().call();
            }
            catch (Exception ex) {
                Logger.getLogger(JAlgorithmParametersPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return hadChanged;
    }

    private class MyPropertiesModel
    extends AbstractPropertiesPanelModel {
        private static final int FIELD_WIDTH = 200;
        private static final int LABEL_WIDTH = 250;
        public static final int ROW_EXPANSION_TYPE = 0;
        public static final int ROW_OFFSET_ZERO = 1;
        public static final int ROW_SCORE_MATCH = 2;
        public static final int ROW_SCORE_MISMATCH = 3;
        public static final int ROW_LENGTH_MODIFIER = 4;
        public static final int ROW_PICKING_DEPTH = 5;
        public static final int ROW_NUCLEU = 6;
        public static final int ROW_NUMAR_SOLUTII = 7;
        public static final int ROW_BONUS_COMPUNERE = 8;

        public int getRowCount() {
            return 9;
        }

        public int getLabelWidth() {
            return 250;
        }

        public Class getClassAt(int row) {
            switch (row) {
                case 0: {
                    return AlgorithmParams.ExpansionType.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 7: {
                    return Integer.class;
                }
                case 8: {
                    return Boolean.class;
                }
            }
            assert (false);
            return null;
        }

        public String getDescriptionAt(int row) {
            switch (row) {
                case 0: {
                    return "Type of expansion";
                }
                case 1: {
                    return "Zero offset";
                }
                case 2: {
                    return "Score match";
                }
                case 3: {
                    return "Score mismatch";
                }
                case 4: {
                    return "Length modifier";
                }
                case 5: {
                    return "Picking depth";
                }
                case 6: {
                    return "Nucleus size";
                }
                case 7: {
                    return "Results number";
                }
                case 8: {
                    return null;
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesEditor createEditorComponentAt(int row) {
            switch (row) {
                case 0: {
                    List<AlgorithmParams.ExpansionType> enumerationValues = Arrays.asList(AlgorithmParams.ExpansionType.values());
                    return new JSliderPropertiesEditor(enumerationValues);
                }
                case 1: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 2: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 3: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 4: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 5: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 6: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 7: {
                    return new JTextFieldPropertiesEditor(200);
                }
                case 8: {
                    return new JCheckBoxPropertiesEditor("Give bonus to insertion candidates");
                }
            }
            assert (false);
            return null;
        }

        public IPropertiesHeader createHeaderComponentAt(int row) {
            switch (row) {
                case 0: {
                    return new JLabelPropertiesHeader("Type of interval expansion");
                }
                case 1: {
                    return new JLabelPropertiesHeader("Advanced expansion parameters");
                }
                case 5: {
                    return new JLabelPropertiesHeader("Result candidates");
                }
            }
            return null;
        }

        public void fireActionRowChanged(int row) {
            switch (row) {
                case 0: {
                    AlgorithmParams.ExpansionType expansionType = (AlgorithmParams.ExpansionType)((Object)this.getEditorComponentAt(0).getValue(AlgorithmParams.ExpansionType.class));
                    AlgorithmParams.ExpansionParameters expansionParameters = JAlgorithmParametersPane.this.algorithmParams.getExpansionParameters(expansionType);
                    this.getEditorComponentAt(1).setValue(Integer.class, (Object)expansionParameters.getOffsetZero());
                    this.getEditorComponentAt(2).setValue(Integer.class, (Object)expansionParameters.getScoreMatch());
                    this.getEditorComponentAt(3).setValue(Integer.class, (Object)expansionParameters.getScoreMismatch());
                    this.getEditorComponentAt(4).setValue(Integer.class, (Object)expansionParameters.getLengthModifier());
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int localZeroOffset = (Integer)this.getEditorComponentAt(1).getValue(Integer.class);
                    int localScoreMatch = (Integer)this.getEditorComponentAt(2).getValue(Integer.class);
                    int localScoreMismatch = (Integer)this.getEditorComponentAt(3).getValue(Integer.class);
                    int localLengthModifier = (Integer)this.getEditorComponentAt(4).getValue(Integer.class);
                    AlgorithmParams.ExpansionParameters localExpansionParameters = new AlgorithmParams.ExpansionParameters(localZeroOffset, localScoreMatch, localScoreMismatch, localLengthModifier);
                    AlgorithmParams.ExpansionType localExpansionType = AlgorithmParams.getExpansionType(localExpansionParameters);
                    this.getEditorComponentAt(0).setValue(AlgorithmParams.ExpansionType.class, (Object)localExpansionType);
                    break;
                }
            }
        }

        public boolean isRowOnNewline(int row) {
            switch (row) {
                default: 
            }
            return true;
        }

        public int getRowHeightAt(int row) {
            switch (row) {
                default: 
            }
            return 0;
        }

        public Object getValueAt(int row) {
            switch (row) {
                case 0: {
                    return JAlgorithmParametersPane.this.algorithmParams.getExpansionType();
                }
                case 1: {
                    return JAlgorithmParametersPane.this.algorithmParams.getOffsetZero();
                }
                case 2: {
                    return JAlgorithmParametersPane.this.algorithmParams.getScoreMatch();
                }
                case 3: {
                    return JAlgorithmParametersPane.this.algorithmParams.getScoreMismatch();
                }
                case 4: {
                    return JAlgorithmParametersPane.this.algorithmParams.getLengthModifier();
                }
                case 5: {
                    return JAlgorithmParametersPane.this.algorithmParams.getPickingDepth();
                }
                case 6: {
                    return JAlgorithmParametersPane.this.algorithmParams.getNucleu();
                }
                case 7: {
                    return JAlgorithmParametersPane.this.algorithmParams.getSolutii();
                }
                case 8: {
                    return JAlgorithmParametersPane.this.algorithmParams.isBonusCompunere();
                }
            }
            assert (false);
            return null;
        }

        public boolean setValueAt(int row, Object newValue) {
            Boolean hasChanged;
            Object oldValue = this.getValueAt(row);
            if (oldValue != null ? this.getValueAt(row).equals(newValue) : newValue == null) {
                return false;
            }
            switch (row) {
                case 0: {
                    hasChanged = false;
                    break;
                }
                case 1: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setOffsetZero(auxInteger);
                    break;
                }
                case 2: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setScoreMatch(auxInteger);
                    break;
                }
                case 3: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setScoreMismatch(auxInteger);
                    break;
                }
                case 4: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setLengthModifier(auxInteger);
                    break;
                }
                case 5: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setPickingDepth(auxInteger);
                    break;
                }
                case 6: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setNucleu(auxInteger);
                    break;
                }
                case 7: {
                    Integer auxInteger = (Integer)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setSolutii(auxInteger);
                    break;
                }
                case 8: {
                    Boolean auxBoolean = (Boolean)newValue;
                    hasChanged = JAlgorithmParametersPane.this.algorithmParams.setBonusCompunere(auxBoolean);
                    break;
                }
                default: {
                    hasChanged = false;
                }
            }
            return hasChanged;
        }
    }
}

