/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.coloredtable.cellrenderers.AbstractColoredCellRenderer;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.JProgressSwingWorker;
import ro.genomeartist.gui.cellrenderers.JTransposonDefaultCellRenderer;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFileSequence;
import ro.genomeartist.gui.controller.settings.SearchFileSet;
import ro.genomeartist.gui.controller.settings.SearchFolder;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.dialogs.JAddFileDialog;
import ro.genomeartist.gui.dialogs.JAddFolderDialog;
import ro.genomeartist.gui.dialogs.JCreateFileDialog;
import ro.genomeartist.gui.icons.JToolbarFisiereIcons;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.utils.JMyBoolean;
import ro.genomeartist.gui.utils.MyGlobalClasses;

public class JSearchFilesPane
extends JPanel
implements ActionListener {
    private JColoredTable tableSearchFiles;
    private MyTableModel tableModel;
    private int scale = 2;
    MultilineHeaderRenderer multirenderer;
    TableRowSorter<TableModel> sorter;
    private IGlobalManager globalManager;
    private SearchFileSet searchFileSet;
    private boolean isTransposon;
    private static final String ACTION_ADD_FOLDER = "add_folder";
    private static final String ACTION_ADD_FILE = "add_node";
    private static final String ACTION_DELETE = "del_node";
    private static final String ACTION_CREATE = "create_node";
    JToolBar toolBar;
    JButton buttonAddFolder;
    JButton buttonAddFile;
    JButton buttonDelete;
    JButton buttonCreate;
    JToolbarFisiereIcons iconToolbarProvider;
    boolean hasChanged;
    private TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0 && e.getColumn() > 0) {
                JSearchFilesPane.this.repaint();
            }
        }
    };

    public JSearchFilesPane(IGlobalManager globalManager, SearchFileSet searchFileSet, boolean isTransposon) {
        this.setLayout(new BorderLayout());
        this.globalManager = globalManager;
        this.isTransposon = isTransposon;
        this.hasChanged = false;
        this.iconToolbarProvider = (JToolbarFisiereIcons)MyGlobalClasses.get((String)"JToolbarFisiereIcons");
        this.searchFileSet = searchFileSet;
        this.tableModel = new MyTableModel(searchFileSet);
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.tableSearchFiles = new JColoredTable((AbstractColoredTableModel)this.tableModel);
        this.tableSearchFiles.setAutoResizeMode(1);
        this.tableSearchFiles.setSelectionMode(2);
        this.tableSearchFiles.getTableHeader().setReorderingAllowed(false);
        this.tableSearchFiles.setShowHorizontalLines(true);
        this.tableSearchFiles.setShowVerticalLines(true);
        this.tableSearchFiles.setDefaultCellRenderer((AbstractColoredCellRenderer)new JTransposonDefaultCellRenderer());
        this.sorter = new TableRowSorter<MyTableModel>(this.tableModel);
        this.tableSearchFiles.setRowSorter(this.sorter);
        this.sorter.toggleSortOrder(0);
        this.sorter.toggleSortOrder(0);
        this.multirenderer = new MultilineHeaderRenderer();
        this.setPrefferedWidth();
        this.toolBar = this.createToolBar();
        this.add((Component)new JScrollPane((Component)this.tableSearchFiles), "Center");
        this.add((Component)this.toolBar, "North");
    }

    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Toolbar");
        this.buttonAddFolder = new JButton("Add folder");
        this.buttonAddFolder.setActionCommand(ACTION_ADD_FOLDER);
        this.buttonAddFolder.setToolTipText("Add all files in a folder");
        this.buttonAddFolder.addActionListener(this);
        this.buttonAddFolder.setIcon(this.iconToolbarProvider.getIcon(1));
        this.buttonAddFolder.setFocusable(false);
        localToolBar.add(this.buttonAddFolder);
        this.buttonAddFile = new JButton("Add file");
        this.buttonAddFile.setActionCommand(ACTION_ADD_FILE);
        this.buttonAddFile.setToolTipText("Add a new file");
        this.buttonAddFile.addActionListener(this);
        this.buttonAddFile.setIcon(this.iconToolbarProvider.getIcon(2));
        this.buttonAddFile.setFocusable(false);
        localToolBar.add(this.buttonAddFile);
        this.buttonDelete = new JButton("Delete file");
        this.buttonDelete.setActionCommand(ACTION_DELETE);
        this.buttonDelete.setToolTipText("Delete existing file");
        this.buttonDelete.addActionListener(this);
        this.buttonDelete.setIcon(this.iconToolbarProvider.getIcon(3));
        this.buttonDelete.setFocusable(false);
        localToolBar.add(this.buttonDelete);
        localToolBar.addSeparator();
        this.buttonDelete = new JButton("Create file");
        this.buttonDelete.setActionCommand(ACTION_CREATE);
        this.buttonDelete.setToolTipText("Create a new file");
        this.buttonDelete.addActionListener(this);
        this.buttonDelete.setIcon(this.iconToolbarProvider.getIcon(4));
        this.buttonDelete.setFocusable(false);
        localToolBar.add(this.buttonDelete);
        localToolBar.setFocusable(false);
        localToolBar.setFloatable(false);
        localToolBar.setRollover(false);
        return localToolBar;
    }

    private void setPrefferedWidth() {
        TableColumnModel columns = this.tableSearchFiles.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(1);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(2);
        column.setHeaderRenderer((TableCellRenderer)this.multirenderer);
        column.setPreferredWidth(100);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ADD_FOLDER.equals(cmd)) {
            this.fireActionAddFolder();
        } else if (ACTION_ADD_FILE.equals(cmd)) {
            this.fireActionAddFile();
        } else if (ACTION_DELETE.equals(cmd)) {
            this.fireActionDeleteFile();
        } else if (ACTION_CREATE.equals(cmd)) {
            this.fireActionCreateFile();
        }
    }

    public void fireActionAddFolder() {
        JMyBoolean isOk = new JMyBoolean();
        JAddFolderDialog dialog = new JAddFolderDialog(this.globalManager, "Add folder", true, isOk);
        dialog.setVisible(true);
        if (isOk.isTrue()) {
            SearchFolder searchFolderRaw = dialog.getFolderRaw();
            if (searchFolderRaw.folderLocation == null) {
                JOptionPane.showMessageDialog(this.globalManager.getTheRootFrame(), "Invalid location", "Error", 0);
                return;
            }
            AbstractProgressCallable<Vector<SearchFile>> callable = ExternalLink.getAddSearchFolderCallable(searchFolderRaw, this.isTransposon);
            JProgressSwingWorker addFolderWorker = new JProgressSwingWorker(this.globalManager.getTheRootFrame(), "Computing", callable, 1);
            addFolderWorker.setStandardErrorMessage("Error while searching");
            Vector newSearchFiles = (Vector)addFolderWorker.executeTask();
            for (SearchFile searchFile : newSearchFiles) {
                this.searchFileSet.add(searchFile);
            }
            this.tableModel.fireTableDataChanged();
            this.hasChanged = true;
        }
    }

    public void fireActionAddFile() {
        JMyBoolean isOk = new JMyBoolean();
        JAddFileDialog dialog = new JAddFileDialog(this.globalManager, "Add file", true, isOk);
        dialog.setVisible(true);
        if (isOk.isTrue()) {
            SearchFile searchFileRaw = dialog.getFileRaw();
            if (searchFileRaw.rawLocation == null) {
                JOptionPane.showMessageDialog(this.globalManager.getTheRootFrame(), "Invalid location", "Error", 0);
                return;
            }
            AbstractProgressCallable<Boolean> callable = ExternalLink.getAddSearchFileCallable(searchFileRaw);
            JProgressSwingWorker addFileWorker = new JProgressSwingWorker(this.globalManager.getTheRootFrame(), "Computing", callable, 1);
            addFileWorker.setStandardErrorMessage("Error while searching");
            addFileWorker.executeTask();
            searchFileRaw.isTransposon = this.isTransposon;
            this.searchFileSet.add(searchFileRaw);
            this.tableModel.fireTableDataChanged();
            this.hasChanged = true;
        }
    }

    public void fireActionDeleteFile() {
        int selectedRow = this.tableSearchFiles.getSelectedRow();
        if (selectedRow == -1) {
            JOptionPane.showMessageDialog(this.globalManager.getTheRootFrame(), "No file selected", "Warning", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.globalManager.getTheRootFrame(), "Are you sure you want to delete the selected files ?", "Confirmation", 0);
        if (n == 0) {
            int[] selectedRows = this.tableSearchFiles.getSelectedRows();
            int[] positionsToDelete = new int[selectedRows.length];
            Vector<SearchFile> vectorDeleteFiles = new Vector<SearchFile>();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                int selectedPosition = this.tableSearchFiles.convertRowIndexToModel(j);
                SearchFile searchFile = (SearchFile)this.searchFileSet.elementAt(selectedPosition);
                vectorDeleteFiles.add(searchFile);
                positionsToDelete[i] = selectedPosition;
            }
            AbstractProgressCallable<Boolean> callable = ExternalLink.getDeleteMultipleFileCallable(vectorDeleteFiles);
            JProgressSwingWorker deleteFilesWorker = new JProgressSwingWorker(this.globalManager.getTheRootFrame(), "Computing", callable, 1);
            deleteFilesWorker.setStandardErrorMessage("Error while searching");
            deleteFilesWorker.executeTask();
            Arrays.sort(positionsToDelete);
            for (int i = positionsToDelete.length - 1; i >= 0; --i) {
                int j = positionsToDelete[i];
                this.searchFileSet.removeElementAt(j);
            }
            this.tableModel.fireTableDataChanged();
            this.hasChanged = true;
        }
    }

    public void fireActionCreateFile() {
        JMyBoolean isOk = new JMyBoolean();
        JCreateFileDialog dialog = new JCreateFileDialog(this.globalManager, "Create file", true, isOk);
        dialog.setVisible(true);
        if (isOk.isTrue()) {
            SearchFileSequence searchFileSequence = dialog.getSearchFileSequence();
            AbstractProgressCallable<SearchFile> callable = ExternalLink.getCreateSearchFileCallable(searchFileSequence);
            JProgressSwingWorker createFileWorker = new JProgressSwingWorker(this.globalManager.getTheRootFrame(), "Computing", callable, 1);
            createFileWorker.setStandardErrorMessage("Error while searching");
            SearchFile searchFileRaw = (SearchFile)createFileWorker.executeTask();
            searchFileRaw.isTransposon = this.isTransposon;
            this.searchFileSet.add(searchFileRaw);
            this.tableModel.fireTableDataChanged();
            this.hasChanged = true;
        }
    }

    public SearchFileSet getSearchFileSet() {
        return this.searchFileSet;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private class MyTableModel
    extends AbstractColoredTableModel {
        private SearchFileSet dataProvider;

        public MyTableModel(SearchFileSet dataProvider) {
            this.dataProvider = dataProvider;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.dataProvider.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Sequence\nlocation";
                }
                case 2: {
                    return "Genes\nlocation";
                }
            }
            assert (false);
            return null;
        }

        public Object getValueAt(int row, int col) {
            Double result = new Double(0.0);
            String output = new String();
            BigDecimal aux = new BigDecimal(1);
            SearchFile searchFile = (SearchFile)this.dataProvider.elementAt(row);
            switch (col) {
                case 0: {
                    return searchFile.fileTitle;
                }
                case 1: {
                    return searchFile.rawLocation.getPath();
                }
                case 2: {
                    return searchFile.geneLocation.getPath();
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Color getBackground(int row, int col) {
            if (JSearchFilesPane.this.isTransposon) {
                return DrawingConstants.COLOR_TABLE_BG_RED;
            }
            return DrawingConstants.COLOR_TABLE_BG_BLUE;
        }

        public Color getForeground(int row, int col) {
            return null;
        }
    }
}

