/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.util.StringTokenizer;
import ro.genomeartist.gui.utils.StringUtils;

public class DNAUtils {
    public static String reverseComplementSequence(String sequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            stringBuilder.append(DNAUtils.complementNucleotide(c));
        }
        return stringBuilder.reverse().toString();
    }

    public static String sanitizeSequence(String sequence) {
        String squeezedString;
        String result = new String();
        result = squeezedString = StringUtils.squeezeString(sequence);
        if (squeezedString.startsWith(">") || squeezedString.startsWith(";")) {
            result = DNAUtils.getSequenceFromFasta(sequence);
        } else if (squeezedString.contains("ORIGIN") && squeezedString.endsWith("//")) {
            result = DNAUtils.getSequenceFromGenbank(sequence);
        }
        result = DNAUtils.cleanString(result);
        return result;
    }

    private static String getSequenceFromFasta(String sequence) {
        String result = new String();
        StringTokenizer st = new StringTokenizer(sequence, "\n", false);
        while (st.hasMoreElements()) {
            String auxString = StringUtils.squeezeString(st.nextToken());
            if (auxString.startsWith(">") || auxString.startsWith(";")) continue;
            result = result + auxString;
        }
        return result;
    }

    private static String getSequenceFromGenbank(String sequence) {
        String result = new String();
        StringTokenizer st = new StringTokenizer(sequence, "\n", false);
        boolean foundOrigin = false;
        while (st.hasMoreElements()) {
            String auxString = StringUtils.squeezeString(st.nextToken());
            if (auxString.startsWith("ORIGIN") || auxString.startsWith("origin") || auxString.startsWith("origin")) {
                foundOrigin = true;
                auxString = auxString.substring("ORIGIN".length());
            }
            if (!foundOrigin) continue;
            result = result + auxString;
        }
        return result;
    }

    private static String cleanString(String sequence) {
        String result = new String();
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (!DNAUtils.isNucleotide(c)) continue;
            result = result + DNAUtils.toNucleotide(c);
        }
        return result;
    }

    public static boolean isNucleotide(char c) {
        switch (c) {
            case '.': 
            case 'A': 
            case 'C': 
            case 'G': 
            case 'N': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 'n': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public static char toNucleotide(char c) {
        switch (c) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': {
                return c;
            }
        }
        return 'N';
    }

    public static char complementNucleotide(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 'T';
            }
            case 'C': 
            case 'c': {
                return 'G';
            }
            case 'G': 
            case 'g': {
                return 'C';
            }
            case 'T': 
            case 't': {
                return 'A';
            }
            case 'N': 
            case 'n': {
                return 'N';
            }
        }
        return c;
    }
}

