/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRXlsDataSource
implements JRRewindableDataSource {
    private Workbook workbook = null;
    private DateFormat dateFormat = new SimpleDateFormat();
    private NumberFormat numberFormat = new DecimalFormat();
    private Map columnNames = new HashMap();
    private boolean useFirstRowAsHeader = false;
    private int recordIndex = -1;
    private InputStream inputStream = null;
    private boolean closeWorkbook = false;

    public JRXlsDataSource(Workbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public JRXlsDataSource(InputStream is) throws JRException, IOException {
        try {
            this.workbook = Workbook.getWorkbook((InputStream)is);
            this.closeWorkbook = true;
        }
        catch (BiffException e) {
            throw new JRException(e);
        }
    }

    public JRXlsDataSource(File file) throws JRException, FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public boolean next() throws JRException {
        ++this.recordIndex;
        if (this.workbook != null) {
            if (this.recordIndex == 0 && this.useFirstRowAsHeader) {
                this.readHeader();
                ++this.recordIndex;
            }
            if (this.recordIndex < this.workbook.getSheet(0).getRows()) {
                return true;
            }
            if (this.closeWorkbook) {
                this.workbook.close();
            }
        }
        return false;
    }

    public void moveFirst() {
        this.recordIndex = -1;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = (Integer)this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.valueOf(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        Sheet sheet = this.workbook.getSheet(0);
        Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
        String fieldValue = cell.getContents();
        Class valueClass = jrField.getValueClass();
        if (valueClass.equals(String.class)) {
            return fieldValue;
        }
        if ((fieldValue = fieldValue.trim()).length() == 0) {
            return null;
        }
        try {
            if (valueClass.equals(Boolean.class)) {
                return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass.equals(Byte.class)) {
                return new Byte(this.numberFormat.parse(fieldValue).byteValue());
            }
            if (valueClass.equals(Integer.class)) {
                return new Integer(this.numberFormat.parse(fieldValue).intValue());
            }
            if (valueClass.equals(Long.class)) {
                return new Long(this.numberFormat.parse(fieldValue).longValue());
            }
            if (valueClass.equals(Short.class)) {
                return new Short(this.numberFormat.parse(fieldValue).shortValue());
            }
            if (valueClass.equals(Double.class)) {
                return new Double(this.numberFormat.parse(fieldValue).doubleValue());
            }
            if (valueClass.equals(Float.class)) {
                return new Float(this.numberFormat.parse(fieldValue).floatValue());
            }
            if (valueClass.equals(BigDecimal.class)) {
                return new BigDecimal(this.numberFormat.parse(fieldValue).toString());
            }
            if (valueClass.equals(BigInteger.class)) {
                return new BigInteger(String.valueOf(this.numberFormat.parse(fieldValue).longValue()));
            }
            if (valueClass.equals(Number.class)) {
                return this.numberFormat.parse(fieldValue);
            }
            if (valueClass.equals(Date.class)) {
                return this.dateFormat.parse(fieldValue);
            }
            if (valueClass.equals(Timestamp.class)) {
                return new Timestamp(this.dateFormat.parse(fieldValue).getTime());
            }
            if (valueClass.equals(Time.class)) {
                return new Time(this.dateFormat.parse(fieldValue).getTime());
            }
            throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
        }
        catch (Exception e) {
            throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
        }
    }

    private void readHeader() {
        Sheet sheet = this.workbook.getSheet(0);
        if (this.columnNames.size() == 0) {
            for (int columnIndex = 0; columnIndex < sheet.getColumns(); ++columnIndex) {
                Cell cell = sheet.getCell(columnIndex, this.recordIndex);
                String columnName = cell.getContents();
                if (columnName == null || columnName.trim().length() <= 0) continue;
                this.columnNames.put(columnName, new Integer(columnIndex));
            }
        } else {
            HashMap<String, Integer> newColumnNames = new HashMap<String, Integer>();
            Iterator it = this.columnNames.values().iterator();
            while (it.hasNext()) {
                Integer columnIndex = (Integer)it.next();
                Cell cell = sheet.getCell(columnIndex.intValue(), this.recordIndex);
                String columnName = cell.getContents();
                newColumnNames.put(columnName, columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.checkReadStarted();
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.checkReadStarted();
        this.numberFormat = numberFormat;
    }

    public void setColumnNames(String[] columnNames) {
        this.checkReadStarted();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], new Integer(i));
        }
    }

    public void setColumnNames(String[] columnNames, int[] columnIndexes) {
        this.checkReadStarted();
        if (columnNames.length != columnIndexes.length) {
            throw new JRRuntimeException("The number of column names must be equal to the number of column indexes.");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], new Integer(columnIndexes[i]));
        }
    }

    public void setColumnIndexes(Integer[] columnIndexes) {
        this.checkReadStarted();
        for (int i = 0; i < columnIndexes.length; ++i) {
            this.columnNames.put("COLUMN_" + i, columnIndexes[i]);
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.checkReadStarted();
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkReadStarted() {
        if (this.recordIndex > 0) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started.");
        }
    }
}

