/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.finalresult;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.interfaces.ICanPaint;
import ro.genomeartist.gui.utils.ReadWriteConfiguration;

public class FinalResultItem
implements ICanPaint {
    private int score;
    private int lengthInitialQuery;
    private int outTotalLength;
    private String out1;
    private String relation;
    private String out2;
    private IntervalMappingSet intervalMappingSet;
    private int offset = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        this.mainPaintMethod(g, width, height, bgColor, fgColor, true);
    }

    public void paintImage(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        String textScore = " Score: ";
        String textValueScore = this.score + "";
        g2d.setColor(Color.BLACK);
        g2d.drawString(textScore, 0, lineHeight - 2);
        Font oldFont = g2d.getFont();
        g2d.setFont(oldFont.deriveFont(1, oldFont.getSize() + 1));
        g2d.drawString(textValueScore, fontMetrics.stringWidth(textScore), lineHeight - 1);
        g2d.setFont(oldFont);
        g.translate(0, lineHeight);
        this.mainPaintMethod(g, width, height - lineHeight, bgColor, fgColor, false);
        g.translate(0, -lineHeight);
    }

    public void mainPaintMethod(Graphics g, int width, int height, Color bgColor, Color fgColor, boolean isBackgroundFilled) {
        int sumInt;
        String auxString;
        Font oldFont;
        int auxInt;
        Color colorIntervalFill;
        Color colorIntervalBorder;
        IntervalMappingItem intervalMappingItem2;
        Graphics2D g2d = (Graphics2D)g;
        int indexWidth = 0;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String leftEnd = new String(" " + this.offset + " ");
        int auxRightEnd = this.offset + this.getLengthInitialQuery() - 1;
        String rightEnd = new String(" " + auxRightEnd + " ");
        int leftTextLength = fontMetrics.stringWidth(leftEnd);
        int rigthTextLength = fontMetrics.stringWidth(rightEnd);
        int chenarWidth = width - 10 - 10 - leftTextLength - rigthTextLength;
        Iterator intervale = this.intervalMappingSet.iterator();
        String prefixSeparator = " - ";
        String suffixSeparator = "  ";
        int prefixWidth = fontMetrics.stringWidth(prefixSeparator);
        int suffixWidth = fontMetrics.stringWidth(suffixSeparator);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        if (isBackgroundFilled) {
            g2d.fillRect(0, 0, width, height);
        }
        int localX = 10 + leftTextLength;
        int localY = 10 + lineHeight;
        int localWidth = chenarWidth;
        int localHeight = lineHeight;
        g2d.setColor(DrawingConstants.COLOR_CHENAR_FILL);
        g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        g2d.setColor(DrawingConstants.COLOR_CHENAR_BORDER);
        g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        localX = 10;
        localY = 10 + 2 * lineHeight - 5;
        g2d.setColor(fgColor);
        g2d.drawString(leftEnd, localX, localY);
        localX = width - 10 - rigthTextLength;
        localY = 10 + 2 * lineHeight - 5;
        g2d.setColor(fgColor);
        g2d.drawString(rightEnd, localX, localY);
        int indexInterval = 1;
        while (intervale.hasNext()) {
            intervalMappingItem2 = (IntervalMappingItem)intervale.next();
            int markerLeft = (int)((double)intervalMappingItem2.pozitieQuery / (double)this.lengthInitialQuery * (double)chenarWidth);
            int intervalLeft = 10 + markerLeft + leftTextLength;
            int markerRight = (int)((double)(intervalMappingItem2.pozitieQuery + intervalMappingItem2.lengthQuery) / (double)this.getLengthInitialQuery() * (double)chenarWidth);
            int intervalRight = 10 + markerRight + leftTextLength;
            int intervalWidth = intervalRight - intervalLeft;
            if (intervalMappingItem2.isTransposon()) {
                colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
            } else {
                colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
            }
            localX = intervalLeft;
            localY = 10 + lineHeight;
            localWidth = intervalWidth;
            localHeight = lineHeight;
            g2d.setColor(colorIntervalFill);
            g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
            g2d.setColor(colorIntervalBorder);
            g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
            if (intervalWidth - 8 > 25) {
                auxInt = (intervalWidth - 25) / 2;
                localX = intervalLeft + auxInt;
                localY = 10 + lineHeight + lineHeight / 2;
                localWidth = 25;
                localHeight = 0;
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX + localWidth, localY + localHeight);
                auxInt = lineHeight / 2 - 4;
                if (intervalMappingItem2.isComplement()) {
                    g2d.drawLine(localX -= 2, localY, localX + auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX + auxInt, localY + auxInt);
                } else {
                    localX = localX + localWidth + 2;
                    g2d.drawLine(localX, localY, localX - auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX - auxInt, localY + auxInt);
                }
            }
            oldFont = g2d.getFont();
            g2d.setFont(oldFont.deriveFont(1, oldFont.getSize() + 1));
            auxString = "[" + indexInterval + "]";
            ++indexInterval;
            indexWidth = g.getFontMetrics().stringWidth(auxString);
            localX = intervalLeft + intervalWidth / 2 - indexWidth / 2;
            localY = 10 + 3 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
            g2d.setFont(oldFont);
            int textMarkerWidth = 4;
            int textMarkerHeight = 6;
            localX = intervalLeft;
            localY = 10 + lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
            localX = intervalLeft;
            localY = 10 + lineHeight - textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            localX = intervalRight;
            localY = 10 + lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
            localX = intervalRight;
            localY = 10 + lineHeight - textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
            g2d.setStroke(new BasicStroke(2.0f));
            textMarkerWidth = 4;
            textMarkerHeight = 6;
            localX = intervalLeft;
            localY = 10 + 2 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
            localX = intervalLeft;
            localY = 10 + 2 * lineHeight + textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            localX = intervalRight;
            localY = 10 + 2 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
            localX = intervalRight;
            localY = 10 + 2 * lineHeight + textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
            g2d.setStroke(new BasicStroke(2.0f));
            textMarkerWidth = 6;
            auxString = intervalMappingItem2.getPozitieStartQuery() + "";
            auxInt = fontMetrics.stringWidth(auxString);
            sumInt = auxInt + 2 * textMarkerWidth;
            if (sumInt < intervalWidth) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + lineHeight - 5;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(intervalMappingItem2.getPozitieStartQuery() + "", localX, localY);
            }
            auxString = intervalMappingItem2.getPozitieStopQuery() + "";
            sumInt = auxInt;
            auxInt = fontMetrics.stringWidth(auxString);
            if ((sumInt += auxInt + 2 * textMarkerWidth + 8) < intervalWidth) {
                localX = intervalRight - auxInt - textMarkerWidth;
                localY = 10 + lineHeight - 5;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(auxString, localX, localY);
            }
            textMarkerWidth = 6;
            auxString = intervalMappingItem2.getPozitieStartGenom() + "";
            auxInt = fontMetrics.stringWidth(auxString);
            sumInt = auxInt + textMarkerWidth + indexWidth / 2;
            if (sumInt < intervalWidth / 2) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + 3 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(auxString, localX, localY);
            }
            auxString = intervalMappingItem2.getPozitieStopGenom() + "";
            sumInt = auxInt;
            auxInt = fontMetrics.stringWidth(auxString);
            if ((sumInt += auxInt + 2 * textMarkerWidth + 8 + indexWidth) >= intervalWidth) continue;
            localX = intervalRight - auxInt - textMarkerWidth;
            localY = 10 + 3 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
        }
        sumInt = 0;
        intervale = this.intervalMappingSet.iterator();
        while (intervale.hasNext()) {
            sumInt += indexWidth;
            sumInt += prefixWidth;
            intervalMappingItem2 = (IntervalMappingItem)intervale.next();
            auxString = intervalMappingItem2.getFisierOrigine();
            auxInt = fontMetrics.stringWidth(auxString);
            sumInt += auxInt;
            sumInt += suffixWidth;
        }
        int linesUsed = sumInt + 10 + 10 < width ? 1 : 2;
        boolean currentLine = true;
        localX = 0;
        localY = height - 10 - linesUsed * lineHeight;
        localWidth = width;
        localHeight = 10 + linesUsed * lineHeight;
        g2d.setColor(bgColor);
        g2d.fillRect(localX, localY, localWidth, localHeight);
        g2d.setColor(DrawingConstants.COLOR_CHENAR_BORDER);
        g2d.drawRect(localX, localY, localWidth, localHeight);
        indexInterval = 1;
        int nextLocalX = 10;
        localY = height - 10 - (linesUsed - 1) * lineHeight;
        for (IntervalMappingItem intervalMappingItem2 : this.intervalMappingSet) {
            if (intervalMappingItem2.isTransposon()) {
                colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
            } else {
                colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
            }
            oldFont = g2d.getFont();
            g2d.setFont(oldFont.deriveFont(1, oldFont.getSize() + 1));
            auxString = "[" + indexInterval + "]";
            ++indexInterval;
            auxInt = g.getFontMetrics().stringWidth(auxString);
            if (nextLocalX + auxInt > width - 10) {
                localX = 10;
                localY += lineHeight;
            } else {
                localX = nextLocalX;
            }
            nextLocalX = localX + auxInt;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
            g2d.setFont(oldFont);
            auxInt = prefixWidth;
            localX = nextLocalX;
            nextLocalX = localX + auxInt;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(prefixSeparator, localX, localY);
            auxString = intervalMappingItem2.getFisierOrigine();
            auxInt = fontMetrics.stringWidth(auxString);
            if (nextLocalX + auxInt > width - 10) {
                localX = 10;
                localY += lineHeight;
            } else {
                localX = nextLocalX;
            }
            nextLocalX = localX + auxInt;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
            auxInt = suffixWidth;
            if (nextLocalX + auxInt > width - 10) {
                localX = 10;
                localY += lineHeight;
            } else {
                localX = nextLocalX;
            }
            nextLocalX = localX + auxInt;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(suffixSeparator, localX, localY);
        }
    }

    public int getRecommendedHeight(JComponent component) {
        Font font = UIManager.getDefaults().getFont("Table.font");
        int lineHeight = component.getFontMetrics(font).getHeight();
        int recommendedSize = 20 + 5 * lineHeight + 10;
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        return 300;
    }

    public int getImageHeight(JComponent component) {
        Font font = UIManager.getDefaults().getFont("Table.font");
        int lineHeight = component.getFontMetrics(font).getHeight();
        int recommendedSize = this.getRecommendedHeight(component) + lineHeight;
        return recommendedSize;
    }

    public int getImageWidth(JComponent component) {
        return 800;
    }

    public IntervalMappingSet getIntervalMappingSet() {
        return this.intervalMappingSet;
    }

    public void setIntervalMappingSet(IntervalMappingSet intervalMappingSet) {
        this.intervalMappingSet = intervalMappingSet;
    }

    public int getLengthInitialQuery() {
        return this.lengthInitialQuery;
    }

    public void setLengthInitialQuery(int lengthInitialQuery) {
        this.lengthInitialQuery = lengthInitialQuery;
    }

    public String getOut1() {
        return this.out1;
    }

    public void setOut1(String out1) {
        this.out1 = out1;
    }

    public String getOut2() {
        return this.out2;
    }

    public void setOut2(String out2) {
        this.out2 = out2;
    }

    public int getOutTotalLength() {
        return this.outTotalLength;
    }

    public void setOutTotalLength(int outTotalLength) {
        this.outTotalLength = outTotalLength;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }
}

