/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.settings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFileSet
extends Vector<SearchFile> {
    private static final String INDICATOR_GENOM = "G";
    private static final String INDICATOR_TRANSPOSON = "T";

    public SearchFileSet() {
    }

    public SearchFileSet(Collection<? extends SearchFile> c) {
        super(c);
    }

    @Override
    public synchronized boolean add(SearchFile e) {
        if (!super.contains(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends SearchFile> c) {
        return super.addAll(c);
    }

    public void loadFromFile() {
        try {
            String line;
            String paramfile = ReadOnlyConfiguration.getString("PARAM_FISIERE");
            BufferedReader fileReader = new BufferedReader(new FileReader(paramfile));
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, " \t");
                SearchFile searchFile = new SearchFile();
                searchFile.rawLocation = new File(st.nextToken());
                searchFile.geneLocation = new File(st.nextToken());
                searchFile.geneNumber = Integer.parseInt(st.nextToken());
                searchFile.fileTitle = st.nextToken();
                String token = st.nextToken();
                if (INDICATOR_GENOM.equals(token)) {
                    searchFile.isTransposon = false;
                } else if (INDICATOR_TRANSPOSON.equals(token)) {
                    searchFile.isTransposon = true;
                }
                this.add(searchFile);
            }
            fileReader.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ResultSet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveToFile() {
        try {
            String paramfile = ReadOnlyConfiguration.getString("PARAM_FISIERE");
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(paramfile, false));
            fileWriter.write("# ");
            fileWriter.write("[SEQ PATH]");
            fileWriter.write("\t");
            fileWriter.write("[GENE PATH]");
            fileWriter.write("\t");
            fileWriter.write("[GENE NUMBER]");
            fileWriter.write("\t");
            fileWriter.write("[FILE TITLE]");
            fileWriter.write("\t");
            fileWriter.write("[GENOM/TRANSPOSON]");
            fileWriter.newLine();
            for (SearchFile searchFile : this) {
                fileWriter.write(searchFile.rawLocation.getPath());
                fileWriter.write("\t");
                fileWriter.write(searchFile.geneLocation.getPath());
                fileWriter.write("\t");
                fileWriter.write(searchFile.geneNumber + "");
                fileWriter.write("\t");
                fileWriter.write(searchFile.fileTitle);
                fileWriter.write("\t");
                if (searchFile.isTransposon) {
                    fileWriter.write(INDICATOR_TRANSPOSON);
                } else {
                    fileWriter.write(INDICATOR_GENOM);
                }
                fileWriter.newLine();
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ReadOnlyConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

