/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.custompaint;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import ro.genomeartist.gui.custompaint.ImageVector;

public class ImageManipulation {
    public static final BufferedImage joinImages(ImageVector images) {
        int resultWidth = 555;
        int resultHeight = 0;
        for (BufferedImage imageItem : images) {
            resultHeight += imageItem.getHeight();
        }
        BufferedImage resultImage = new BufferedImage(resultWidth, resultHeight, 2);
        Iterator imageIterator = images.iterator();
        int localY = 0;
        while (imageIterator.hasNext()) {
            BufferedImage imageItem = (BufferedImage)imageIterator.next();
            int localHeight = imageItem.getHeight();
            BufferedImage drawingImage = resultImage.getSubimage(0, localY, resultWidth, localHeight);
            Graphics2D g2d = (Graphics2D)drawingImage.getGraphics();
            g2d.drawImage((Image)imageItem, 0, 0, null);
            localY += localHeight;
        }
        return resultImage;
    }

    public static final ImageVector splitImage(BufferedImage bigImage, int splitSize) {
        BufferedImage cellImage;
        ImageVector images = new ImageVector();
        int cellWidth = bigImage.getWidth();
        int cellHeight = splitSize;
        int pieces = bigImage.getHeight() / cellHeight;
        for (int i = 0; i < pieces; ++i) {
            cellImage = new BufferedImage(cellWidth, cellHeight, 2);
            cellImage = bigImage.getSubimage(0, i * cellHeight, cellWidth, cellHeight);
            images.add(cellImage);
        }
        int leftover = bigImage.getHeight() % cellHeight;
        if (leftover != 0) {
            cellImage = new BufferedImage(cellWidth, cellHeight, 2);
            cellImage = bigImage.getSubimage(0, pieces * cellHeight, cellWidth, leftover);
            images.add(cellImage);
        }
        return images;
    }
}

