/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import ro.genomeartist.components.dialogs.JTwoButtonAbstractDialog;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.JProgressSwingWorker;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.GeneralSettings;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;
import ro.genomeartist.gui.mainpanels.settings.JSettingsPane;

public class JSettingsDialog
extends JTwoButtonAbstractDialog {
    private static final int FRAME_WIDTH = 700;
    private static final int FRAME_HEIGHT = 500;
    private static final String BUTTON_OK = "    Ok    ";
    private static final String BUTTON_CANCEL = "  Cancel  ";
    private IGlobalManager globalManager;
    private ILocalManager localManager;
    private GeneralSettings generalSettings;
    private JSettingsPane settingsPane;

    public JSettingsDialog(IGlobalManager globalManager, String title, boolean modal, GeneralSettings generalSettings) {
        super(globalManager.getTheRootFrame(), title, modal);
        this.setSize(700, 500);
        this.globalManager = globalManager;
        this.generalSettings = generalSettings;
        this.setTextOk(BUTTON_OK);
        this.setTextCancel(BUTTON_CANCEL);
        this.setResizable(true);
        this.settingsPane = new JSettingsPane(globalManager, generalSettings);
        this.setCenterComponent(this.settingsPane);
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    public void fireActionOk() {
        AplicaSetariCallableAction callable = new AplicaSetariCallableAction();
        JProgressSwingWorker<Boolean> settingsWorker = new JProgressSwingWorker<Boolean>(this.globalManager.getTheRootFrame(), "Applying new settings", callable, 0);
        settingsWorker.setStandardErrorMessage("Error applying settings !");
        settingsWorker.executeTask();
        this.dispose();
    }

    public void fireActionCancel() {
        AplicaSetariCallableAction callable = new AplicaSetariCallableAction(false);
        JProgressSwingWorker<Boolean> settingsWorker = new JProgressSwingWorker<Boolean>(this.globalManager.getTheRootFrame(), "Canceling settings", callable, 0);
        settingsWorker.setStandardErrorMessage("Error canceling settings !");
        settingsWorker.executeTask();
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AplicaSetariCallableAction
    extends AbstractProgressCallable<Boolean> {
        boolean applyAlgorithmChanges;

        public AplicaSetariCallableAction() {
            this(true);
        }

        public AplicaSetariCallableAction(boolean applyAlgorithmChanges) {
            this.applyAlgorithmChanges = applyAlgorithmChanges;
        }

        @Override
        public Boolean call() throws Exception {
            boolean auxFlag;
            boolean hasChanged = false;
            if (this.applyAlgorithmChanges) {
                auxFlag = JSettingsDialog.this.settingsPane.fireActionApplyAlgorithmParams();
                hasChanged = hasChanged || auxFlag;
            }
            auxFlag = JSettingsDialog.this.settingsPane.fireActionApplyFileParams();
            boolean bl = hasChanged = hasChanged || auxFlag;
            if (hasChanged) {
                ExternalLink.stopServer();
                AbstractProgressCallable<Boolean> startServerCallable = ExternalLink.getStartServerCallable();
                startServerCallable.setProgressInfoManager(this);
                startServerCallable.call();
            }
            return hasChanged;
        }
    }
}

