/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.icons;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ro.genomeartist.components.singleton.IGlobalClass;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class JToolbarFinalResultIcons
implements IGlobalClass {
    public static final String GLOBAL_NAME = "JToolbarFinalResultIcons";
    public static final int EXPORT = 1;
    public static final int EXPORT_IMAGE = 2;
    public static final int EXPORT_PDF = 3;
    public static final int PRINT = 4;
    public static final int BEST_RESULT = 5;
    private Image iconExport;
    private Image iconExportImage;
    private Image iconExportPdf;
    private Image iconPrint;
    private Image iconBestResult;
    private ImageIcon imageIconExport;
    private ImageIcon imageIconExportImage;
    private ImageIcon imageIconExportPdf;
    private ImageIcon imageIconPrint;
    private ImageIcon imageIconBestResult;
    private Icon noIcon = null;

    public JToolbarFinalResultIcons() {
        this.loadIcons();
    }

    public void loadIcons() {
        String iconsFolder = ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_FOLDER");
        String iconsPath = iconsFolder + ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_EXPORT");
        this.iconExport = MyUtils.createImage(iconsPath);
        this.imageIconExport = new ImageIcon(this.iconExport);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_EXPORT_IMAGE");
        this.iconExportImage = MyUtils.createImage(iconsPath);
        this.imageIconExportImage = new ImageIcon(this.iconExportImage);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_EXPORT_PDF");
        this.iconExportPdf = MyUtils.createImage(iconsPath);
        this.imageIconExportPdf = new ImageIcon(this.iconExportPdf);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_PRINT");
        this.iconPrint = MyUtils.createImage(iconsPath);
        this.imageIconPrint = new ImageIcon(this.iconPrint);
        iconsPath = iconsFolder + ReadOnlyConfiguration.getString("TOOLBAR_FINAL_RESULT_BEST_RESULT");
        this.iconBestResult = MyUtils.createImage(iconsPath);
        this.imageIconBestResult = new ImageIcon(this.iconBestResult);
    }

    public Icon getIcon(int type) {
        switch (type) {
            case 1: {
                if (this.iconExport != null) {
                    return this.imageIconExport;
                }
                return this.noIcon;
            }
            case 2: {
                if (this.iconExportImage != null) {
                    return this.imageIconExportImage;
                }
                return this.noIcon;
            }
            case 3: {
                if (this.iconExportPdf != null) {
                    return this.imageIconExportPdf;
                }
                return this.noIcon;
            }
            case 4: {
                if (this.iconPrint != null) {
                    return this.imageIconPrint;
                }
                return this.noIcon;
            }
            case 5: {
                if (this.iconBestResult != null) {
                    return this.imageIconBestResult;
                }
                return this.noIcon;
            }
        }
        return this.noIcon;
    }

    public String getGlobalName() {
        return GLOBAL_NAME;
    }
}

