/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.finalresult;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.gui.cellrenderers.JBoldIntegerCellRenderer;
import ro.genomeartist.gui.cellrenderers.JDefferPaintCellRenderer;
import ro.genomeartist.gui.cellrenderers.JTransposonDefaultCellRenderer;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.FinalResultSet;
import ro.genomeartist.gui.custompaint.BoldInteger;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.dialogs.JFinalResultItemDialog;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;

public class JFinalResultSetPane
extends JPanel {
    private FinalResultSet finalResultSet;
    private JColoredTable tableFinalResults;
    private MyTableModel tableModel;
    private int scale = 2;
    private static final int COL_MAX_WIDTH = 70;
    MultilineHeaderRenderer multirenderer;
    IGlobalManager globalManager;
    ILocalManager localManager;
    private TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0 && e.getColumn() > 0) {
                JFinalResultSetPane.this.repaint();
            }
        }
    };
    private MouseAdapter clickListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = JFinalResultSetPane.this.tableFinalResults.rowAtPoint(e.getPoint());
                FinalResultItem selectedItem = (FinalResultItem)JFinalResultSetPane.this.finalResultSet.elementAt(row);
                JFinalResultItemDialog dialog = new JFinalResultItemDialog(JFinalResultSetPane.this.globalManager, JFinalResultSetPane.this.localManager, "Result candidate", selectedItem);
                dialog.setVisible(true);
            }
        }
    };

    public JFinalResultSetPane(IGlobalManager globalManager, ILocalManager localManager, FinalResultSet finalResultSet) {
        this.setLayout(new BorderLayout());
        this.globalManager = globalManager;
        this.localManager = localManager;
        this.finalResultSet = finalResultSet;
        this.tableModel = new MyTableModel(finalResultSet);
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.tableFinalResults = new JColoredTable(this.tableModel);
        this.tableFinalResults.setAutoResizeMode(1);
        this.tableFinalResults.setSelectionMode(0);
        this.tableFinalResults.getTableHeader().setReorderingAllowed(false);
        this.tableFinalResults.setShowHorizontalLines(true);
        this.tableFinalResults.setShowVerticalLines(true);
        this.tableFinalResults.setRowHeight(new FinalResultItem().getRecommendedHeight(this));
        this.tableFinalResults.setDefaultCellRenderer(new JTransposonDefaultCellRenderer());
        this.tableFinalResults.setDefaultRenderer(FinalResultItem.class, new JDefferPaintCellRenderer());
        this.tableFinalResults.setDefaultRenderer(BoldInteger.class, new JBoldIntegerCellRenderer());
        this.tableFinalResults.addMouseListener(this.clickListener);
        this.multirenderer = new MultilineHeaderRenderer();
        this.setPrefferedWidth();
        this.add((Component)new JScrollPane(this.tableFinalResults), "Center");
    }

    private void setPrefferedWidth() {
        TableColumnModel columns = this.tableFinalResults.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(70);
        column.setMaxWidth(70);
        column = columns.getColumn(1);
        column.setHeaderRenderer(this.multirenderer);
        column.setPreferredWidth(400);
    }

    private class MyTableModel
    extends AbstractColoredTableModel {
        private FinalResultSet dataProvider;

        public MyTableModel(FinalResultSet dataProvider) {
            this.dataProvider = dataProvider;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.dataProvider.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Score";
                }
                case 1: {
                    return "Sequence\nMapping";
                }
            }
            assert (false);
            return null;
        }

        public Object getValueAt(int row, int col) {
            Double result = new Double(0.0);
            String output = new String();
            BigDecimal aux = new BigDecimal(1);
            FinalResultItem finalResultItem = (FinalResultItem)this.dataProvider.elementAt(row);
            switch (col) {
                case 0: {
                    return new BoldInteger(finalResultItem.getScore());
                }
                case 1: {
                    return finalResultItem;
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return BoldInteger.class;
                }
                case 1: {
                    return FinalResultItem.class;
                }
            }
            assert (false);
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }

        public Color getBackground(int row, int col) {
            return DrawingConstants.COLOR_TABLE_BG_YELLOW;
        }

        public Color getForeground(int row, int col) {
            return null;
        }
    }
}

