/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.partialresult;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultItemAlignment;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.custompaint.JDefferedPanel;
import ro.genomeartist.gui.utils.MyUtils;

public class JPartialResultItemPane
extends JPanel {
    private static final String TITLE_ALIGNMENT = "Alignment";
    private static final String TITLE_MAPPING = "Mapping";
    private static final String TEXT_SCORE = "Score";
    private static final String TEXT_LENGTH_QUERY = "Length in query";
    private static final String TEXT_LENGTH_LOCATION = "Length in location";
    private static final String TEXT_LOCATION = "Location";
    private static final String TEXT_POSITION_QUERY = "Position in query";
    private static final String TEXT_POSITION_LOCATION = "Position in location";
    private static final String TEXT_STRAND = "Strand";
    private static final String TEXT_STRAND_FORWARD = "forward";
    private static final String TEXT_STRAND_COMPLEMENTARY = "complement";
    private PartialResultItem partialResultItem;
    private JPanel infoPanel;
    private JPanel alignmentPanel;
    private JPanel scorePanel;
    private JLabel labelTextScore;
    private JLabel labelValueScore;
    private JPanel lengthQueryPanel;
    private JLabel labelTextLengthQuery;
    private JLabel labelValueLengthQuery;
    private JPanel lengthLocationPanel;
    private JLabel labelTextLengthLocation;
    private JLabel labelValueLengthLocation;
    private JPanel mappingPanel;
    private JPanel locationPanel;
    private JLabel labelTextLocation;
    private JLabel labelValueLocation;
    private JPanel positionQueryPanel;
    private JLabel labelTextPositionQuery;
    private JLabel labelValuePositionQuery;
    private JPanel positionLocationPanel;
    private JLabel labelTextPositionLocation;
    private JLabel labelValuePositionLocation;
    private JPanel strandPanel;
    private JLabel labelTextStrand;
    private JLabel labelValueStrand;
    private JPanel summaryPanel;
    private JPanel swPanel;

    public JPartialResultItemPane(PartialResultItem partialResultItem) {
        this.partialResultItem = partialResultItem;
        this.setLayout(new BoxLayout(this, 1));
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new GridLayout(1, 2));
        this.alignmentPanel = new JPanel();
        this.alignmentPanel.setLayout(new BoxLayout(this.alignmentPanel, 1));
        this.alignmentPanel.setBorder(BorderFactory.createTitledBorder(TITLE_ALIGNMENT));
        this.labelTextScore = new JLabel(TEXT_SCORE);
        MyUtils.setLabelBold(this.labelTextScore);
        this.labelValueScore = new JLabel(partialResultItem.getScore() + "");
        MyUtils.setLabelBold(this.labelValueScore);
        this.scorePanel = this.createAlignedPane(this.labelTextScore, this.labelValueScore);
        this.alignmentPanel.add(this.scorePanel);
        this.labelTextLengthQuery = new JLabel(TEXT_LENGTH_QUERY);
        this.labelValueLengthQuery = new JLabel(partialResultItem.getLengthQuery() + "");
        this.lengthQueryPanel = this.createAlignedPane(this.labelTextLengthQuery, this.labelValueLengthQuery);
        this.alignmentPanel.add(this.lengthQueryPanel);
        this.labelTextLengthLocation = new JLabel(TEXT_LENGTH_LOCATION);
        this.labelValueLengthLocation = new JLabel(partialResultItem.getLengthGenom() + "");
        this.lengthLocationPanel = this.createAlignedPane(this.labelTextLengthLocation, this.labelValueLengthLocation);
        this.alignmentPanel.add(this.lengthLocationPanel);
        this.infoPanel.add(this.alignmentPanel);
        this.mappingPanel = new JPanel();
        this.mappingPanel.setLayout(new BoxLayout(this.mappingPanel, 1));
        this.mappingPanel.setBorder(BorderFactory.createTitledBorder(TITLE_MAPPING));
        this.labelTextLocation = new JLabel(TEXT_LOCATION);
        MyUtils.setLabelBold(this.labelTextLocation);
        this.labelValueLocation = new JLabel(partialResultItem.getFisierOrigine() + "");
        MyUtils.setLabelBold(this.labelValueLocation);
        this.locationPanel = this.createAlignedPane(this.labelTextLocation, this.labelValueLocation);
        this.mappingPanel.add(this.locationPanel);
        this.labelTextPositionQuery = new JLabel(TEXT_POSITION_QUERY);
        this.labelValuePositionQuery = new JLabel(partialResultItem.getPozitieStartQuery() + " .. " + partialResultItem.getPozitieStopQuery());
        this.positionQueryPanel = this.createAlignedPane(this.labelTextPositionQuery, this.labelValuePositionQuery);
        this.mappingPanel.add(this.positionQueryPanel);
        this.labelTextPositionLocation = new JLabel(TEXT_POSITION_LOCATION);
        this.labelValuePositionLocation = new JLabel(partialResultItem.getPozitieStartGenom() + " .. " + partialResultItem.getPozitieStopGenom());
        this.positionLocationPanel = this.createAlignedPane(this.labelTextPositionLocation, this.labelValuePositionLocation);
        this.mappingPanel.add(this.positionLocationPanel);
        this.labelTextStrand = new JLabel(TEXT_STRAND);
        this.labelValueStrand = partialResultItem.isComplement() ? new JLabel(TEXT_STRAND_COMPLEMENTARY) : new JLabel(TEXT_STRAND_FORWARD);
        this.strandPanel = this.createAlignedPane(this.labelTextStrand, this.labelValueStrand);
        this.mappingPanel.add(this.strandPanel);
        this.infoPanel.add(this.mappingPanel);
        this.add(this.infoPanel);
        this.summaryPanel = new JDefferedPanel(partialResultItem);
        this.add(this.summaryPanel);
        this.swPanel = new JDefferedPanel(new PartialResultItemAlignment(partialResultItem));
        this.add(new JScrollPane(this.swPanel));
    }

    private JPanel createAlignedPane(JLabel label1, JLabel label2) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label1);
        panel.add(Box.createHorizontalGlue());
        panel.add(label2);
        if (this.partialResultItem.isTransposon()) {
            label2.setForeground(DrawingConstants.COLOR_TRANSPOSON_BORDER);
        } else {
            label2.setForeground(DrawingConstants.COLOR_GENOM_BORDER);
        }
        return panel;
    }
}

