/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.reports.compile;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;

public class JCompileAllReportsByFolder {
    private static final String JRXML = "jrxml";
    private static final String JASPER = "jasper";
    FileFilter fileFilter = new FileFilter(){

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return false;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equals(JCompileAllReportsByFolder.JRXML);
            }
            return false;
        }

        public String getDescription() {
            return "Doar devize";
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    };

    public void compileAllReports(String folderSursa, String folderDestinatie) {
        Vector<Node> rapoarte = new Vector<Node>();
        File templateFolder = new File(folderSursa);
        File[] templateFiles = templateFolder.listFiles(this.fileFilter);
        for (int i = 0; i < templateFiles.length; ++i) {
            File file = templateFiles[i];
            String basename = JCompileAllReportsByFolder.getBasename(file.getName());
            String path = folderDestinatie + "/" + basename + "." + JASPER;
            rapoarte.add(new Node(file.getPath(), path));
        }
        for (Node node : rapoarte) {
            try {
                System.out.println("COMPILING: " + node.sursa);
                JasperCompileManager.compileReportToFile((String)node.sursa, (String)node.destinatie);
            }
            catch (JRException ex) {
                System.err.println("Could not compile " + node.sursa);
                ex.printStackTrace();
            }
        }
        System.out.println("DONE");
    }

    public static String getBasename(String name) {
        int min;
        String base = null;
        String s = name;
        int pos = s.lastIndexOf(46);
        if (pos <= (min = s.lastIndexOf(47)) || pos >= s.length() - 1) {
            return s;
        }
        base = s.substring(0, pos);
        return base;
    }

    public static void main(String[] args) {
        String folderDestinatie;
        String folderSursa;
        if (args.length < 2) {
            folderSursa = "./report/templates";
            folderDestinatie = "./report/compiled";
        } else {
            folderSursa = args[0];
            folderDestinatie = args[1];
        }
        JCompileAllReportsByFolder compiler = new JCompileAllReportsByFolder();
        compiler.compileAllReports(folderSursa, folderDestinatie);
    }

    private static class Node {
        public String sursa;
        public String destinatie;

        public Node(String sursa, String destinatie) {
            this.sursa = sursa;
            this.destinatie = destinatie;
        }
    }
}

