/*
 * Decompiled with CFR 0.152.
 */
package testing.probability.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class ProbabilityDrafts {
    public static double computeCasesOfConsecutiveHeads(int n, int k) {
        if (n == k) {
            return 1.0;
        }
        if (n < k) {
            return 0.0;
        }
        double term1 = 2.0 * ProbabilityDrafts.computeCasesOfConsecutiveHeads(n - 1, k);
        double term2 = Math.pow(2.0, n - k - 1);
        double term3 = ProbabilityDrafts.computeCasesOfConsecutiveHeads(n - k - 1, k);
        return term1 + term2 - term3;
    }

    public static double computeProbabilityOfConsecutiveHeadsA(int n, int k) {
        double favorable_cases = ProbabilityDrafts.computeCasesOfConsecutiveHeads(n, k);
        double total_cases = Math.pow(2.0, n);
        double result = favorable_cases / total_cases;
        return result;
    }

    public static BigInteger kStepFib(int k, int n) {
        int arraySize = n + 1;
        if (arraySize < 3) {
            arraySize = 3;
        }
        BigInteger[] fibs = new BigInteger[arraySize];
        fibs[0] = new BigInteger("0");
        fibs[1] = new BigInteger("1");
        fibs[2] = new BigInteger("1");
        for (int i = 3; i <= n; ++i) {
            BigInteger fib = new BigInteger("0");
            int start = i - k;
            for (int j = i - k; j < i; ++j) {
                if (j <= 0) continue;
                fib = fib.add(fibs[j]);
            }
            fibs[i] = fib;
            if (start >= 0) {
                fibs[start] = null;
            }
            if (i % 1000 != 0) continue;
            System.out.print("i= " + i + "\r");
        }
        return fibs[n];
    }

    public static BigDecimal computeProbabilityOfConsecutiveHeadsB(int n, int k) {
        int showdigits = 20;
        BigDecimal f = new BigDecimal(ProbabilityDrafts.kStepFib(k, n + 2));
        BigDecimal p = new BigDecimal(new BigInteger("2").pow(n));
        String fs = f.toString();
        String ps = p.toString();
        BigDecimal answer = f.divide(p);
        answer = new BigDecimal(1).subtract(answer);
        String s = answer.toString();
        return answer;
    }

    public static double computeProbabilityOfConsecutiveHeadsC(int n, int k, double headProbability) {
        double numCoins = n;
        double minHeads = k;
        double result = 0.0;
        double[] computedProbability = new double[n + 1];
        computedProbability[0] = 0.0;
        for (int i = 1; i <= n; ++i) {
            double intermediateResult;
            if (k > i) {
                intermediateResult = 0.0;
            } else {
                intermediateResult = Math.pow(headProbability, minHeads);
                for (int j = 1; j < k + 1; ++j) {
                    double auxDouble = Math.pow(headProbability, j - 1) * (1.0 - headProbability);
                    double auxProbability = i < j ? 0.0 : computedProbability[i - j];
                    intermediateResult += auxDouble * auxProbability;
                }
            }
            computedProbability[i] = intermediateResult;
        }
        System.out.println("Vector: " + Arrays.toString(computedProbability));
        return computedProbability[n];
    }

    public static double computeProbabilityOfOverlappedWindows(int n, int k, double headProbability) {
        double minHeads = k;
        double[] computedProbability = new double[n + 1];
        computedProbability[0] = 0.0;
        for (int i = 1; i <= n; ++i) {
            double intermediateResult;
            if (k > i) {
                intermediateResult = 0.0;
            } else {
                intermediateResult = Math.pow(headProbability, minHeads);
                for (int j = 1; j < k + 1; ++j) {
                    double auxDouble = Math.pow(headProbability, j - 1) * (1.0 - headProbability);
                    double auxProbability = i < j ? 0.0 : computedProbability[i - j];
                    intermediateResult += auxDouble * auxProbability;
                }
            }
            computedProbability[i] = intermediateResult;
        }
        return computedProbability[n];
    }

    public static double computeProbabilityOfNonOverlappedWindows(int n, int k, double headProbability) {
        double e1 = Math.pow(headProbability, k);
        double e2 = 1.0 - e1;
        int numberOfWindows = (int)Math.floor((double)n / (double)k);
        double e3 = Math.pow(e2, numberOfWindows);
        double result = 1.0 - e3;
        return result;
    }

    public static void main(String[] args) {
        int n = 100;
        int k = 14;
        double result1 = 0.0;
        BigDecimal result2 = BigDecimal.ZERO;
        double result3 = 0.0;
        long start_time = System.currentTimeMillis();
        long time1 = System.currentTimeMillis();
        long time2 = System.currentTimeMillis();
        result3 = ProbabilityDrafts.computeProbabilityOfConsecutiveHeadsC(n, k, 0.81);
        long time3 = System.currentTimeMillis();
        long res_time1 = time1 - start_time;
        System.out.println("result1 = " + result1);
        System.out.println("time1 = " + res_time1);
        long res_time2 = time2 - time1;
        System.out.println("result2 = " + result2);
        System.out.println("time2 = " + res_time2);
        long res_time3 = time3 - time2;
        System.out.println("result3 = " + result3);
        System.out.println("time3 = " + res_time3);
    }
}

