/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.coloredtable.test;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.components.coloredtable.AbstractColoredTableModel;
import ro.genomeartist.components.coloredtable.JColoredTable;
import ro.genomeartist.components.headerrenderer.JHeaderSorterIcons;
import ro.genomeartist.components.headerrenderer.MultilineHeaderRenderer;
import ro.genomeartist.components.jtable.viewportcontainer.JScrollableBottomSpacingContainer;
import ro.genomeartist.components.utils.WindowUtilities;

public class JColoredTableTestClass {
    private static void createAndShowGUI() {
        WindowUtilities.initLookAndFeel();
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(3);
        AbstractColoredTableModel tableModel = new AbstractColoredTableModel(){

            @Override
            public Color getBackground(int row, int col) {
                if (col > 0) {
                    return Color.RED;
                }
                return Color.CYAN;
            }

            @Override
            public Color getForeground(int row, int col) {
                return null;
            }

            @Override
            public int getRowCount() {
                return 30;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int column) {
                if (column >= 0) {
                    return "column " + column;
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return "[" + rowIndex + "," + columnIndex + "]";
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getTooltipText(int row, int col) {
                switch (col) {
                    case 0: 
                    case 1: {
                        return "test";
                    }
                }
                return null;
            }

            @Override
            public Icon getCellIcon(int row, int col) {
                switch (col) {
                    case 1: {
                        return JHeaderSorterIcons.ASC.getIcon();
                    }
                }
                return null;
            }
        };
        JColoredTable coloredTable = new JColoredTable(tableModel);
        coloredTable.setRowHeight(coloredTable.getRowHeight());
        coloredTable.setFillsViewportHeight(true);
        TableRowSorter<1> tableSorter = new TableRowSorter<1>(tableModel);
        coloredTable.setRowSorter(tableSorter);
        tableSorter.toggleSortOrder(0);
        MultilineHeaderRenderer multirenderer = new MultilineHeaderRenderer();
        TableColumnModel columns = coloredTable.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(1);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(200);
        column = columns.getColumn(2);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(10);
        JScrollableBottomSpacingContainer containerPanel = new JScrollableBottomSpacingContainer(coloredTable);
        JScrollPane scrollPane = new JScrollPane(containerPanel);
        frame.add(scrollPane);
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JColoredTableTestClass.createAndShowGUI();
            }
        });
    }
}

