/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.textarea.fixedwidth;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import ro.genomeartist.components.popup.CopyPastePopupManager;

public class JFixedWidthTextArea
extends JTextArea {
    public JFixedWidthTextArea() {
        this(1, 0);
    }

    public JFixedWidthTextArea(int rows, int width) {
        this("", rows, width);
    }

    public JFixedWidthTextArea(String text, int rows, int width) {
        super(text);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setRows(rows);
        this.configureFixedWidth(width);
        this.setCopyPastePopupEnabled(true);
    }

    public void setFixedWidth(int width) {
        this.configureFixedWidth(width);
    }

    public void setCopyPastePopupEnabled(boolean shouldEnable) {
        MouseListener popupTrigger = CopyPastePopupManager.getCopyPastePopup().getPopupTrigger();
        this.removeMouseListener(popupTrigger);
        if (shouldEnable) {
            this.addMouseListener(popupTrigger);
        }
    }

    private void configureFixedWidth(int width) {
        if (width > 0) {
            int columnWidth = this.getColumnWidth();
            this.setColumns(width / columnWidth);
            this.setMaximumSize(new Dimension(width, width));
        }
    }
}

