/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import exenne.components.headerrenderer.JHeaderSorterIcons;
import exenne.components.headerrenderer.MultilineHeaderRenderer;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class JColoredTableTestClass {
    private static void createAndShowGUI() {
        JColoredTableTestClass.initLookAndFeel();
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(3);
        JHeaderSorterIcons iconProvider = new JHeaderSorterIcons();
        iconProvider.loadIcons();
        AbstractColoredTableModel tableModel = new AbstractColoredTableModel(){

            public Color getBackground(int row) {
                return Color.CYAN;
            }

            public Color getForeground(int row) {
                return null;
            }

            public int getRowCount() {
                return 10;
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int column) {
                if (column >= 0) {
                    return "column " + column;
                }
                return null;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return "[" + rowIndex + "," + columnIndex + "]";
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                assert (false);
                return null;
            }

            public boolean isCellEditable(int row, int col) {
                switch (col) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            public String getTooltipText(int row, int col) {
                switch (col) {
                    case 0: 
                    case 1: {
                        return "test";
                    }
                }
                return null;
            }
        };
        JColoredTable coloredTable = new JColoredTable(tableModel);
        coloredTable.setRowHeight(coloredTable.getRowHeight());
        TableRowSorter<1> tableSorter = new TableRowSorter<1>(tableModel);
        coloredTable.setRowSorter(tableSorter);
        tableSorter.toggleSortOrder(0);
        MultilineHeaderRenderer multirenderer = new MultilineHeaderRenderer();
        TableColumnModel columns = coloredTable.getColumnModel();
        TableColumn column = columns.getColumn(0);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        column = columns.getColumn(1);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(200);
        column = columns.getColumn(2);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(10);
        frame.add(new JScrollPane(coloredTable));
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JColoredTableTestClass.createAndShowGUI();
            }
        });
    }
}

