/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.celleditors;

import exenne.components.treetable.SelfManagedComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class MultiLineTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JTextArea textArea = new ResizableTextArea();
    protected int clickCountToStart = 2;
    public static final String UPDATE_BOUNDS = "UpdateBounds";

    public MultiLineTableCellEditor() {
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.textArea.registerKeyboardAction(this, KeyStroke.getKeyStroke(10, 2), 0);
    }

    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    public boolean isCellEditable(EventObject e) {
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
    }

    public void actionPerformed(ActionEvent ae) {
        this.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text = value != null ? value.toString() : "";
        this.textArea.setText(text);
        return this.textArea;
    }

    class ResizableTextArea
    extends JTextArea
    implements SelfManagedComponent {
        DocumentListener listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            public void removeUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            public void changedUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }
        };

        ResizableTextArea() {
        }

        public void setBounds(int x, int y, int width, int height) {
            if (Boolean.TRUE.equals(this.getClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS))) {
                super.setBounds(x, y, width, height);
            }
        }

        public void addNotify() {
            super.addNotify();
            this.getDocument().addDocumentListener(this.listener);
        }

        public void removeNotify() {
            this.getDocument().removeDocumentListener(this.listener);
            super.removeNotify();
        }

        public void updateBounds(Rectangle cellRect) {
            Dimension prefSize = this.getPreferredSize();
            this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.TRUE);
            this.setBounds(cellRect.x, cellRect.y, Math.max(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
            this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.FALSE);
            this.validate();
        }

        private void updateBounds() {
            JTable table;
            if (this.getParent() instanceof JTable && (table = (JTable)this.getParent()).isEditing()) {
                Rectangle cellRect = table.getCellRect(table.getEditingRow(), table.getEditingColumn(), false);
                Dimension prefSize = this.getPreferredSize();
                this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.TRUE);
                this.setBounds(this.getX(), this.getY(), Math.max(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
                this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.FALSE);
                this.validate();
            }
        }
    }
}

