/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.filter;

import exenne.components.coloredtable.filter.GeneralRowFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.RowFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexRowFilter
extends GeneralRowFilter {
    private Matcher matcher;
    private Pattern regex;

    private RegexRowFilter(String regexString, int[] columns) {
        super(columns);
        this.regex = Pattern.compile(regexString.toLowerCase());
        if (this.regex == null) {
            throw new IllegalArgumentException("Pattern must be non-null");
        }
        this.matcher = this.regex.matcher("");
    }

    @Override
    protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> value, int index) {
        this.matcher.reset(value.getStringValue(index).toLowerCase());
        return this.matcher.find();
    }

    public static <M, I> RowFilter<M, I> getRegexFilter(String regex, int ... indices) {
        return new RegexRowFilter(regex, indices);
    }
}

