/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.glasspane;

import exenne.components.glasspane.IDoScreenshot;
import exenne.components.glasspane.JMessagePane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JPanel;

public class JGlasspaneMessage
extends JPanel {
    BufferedImage fakeScreen;
    JMessagePane messagePane;
    IDoScreenshot parent;
    MouseListener mouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    };
    MouseMotionListener mousemotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    };
    ComponentListener componentListener = new ComponentListener(){

        public void componentResized(ComponentEvent e) {
            JGlasspaneMessage.this.parent.refresh();
            JGlasspaneMessage.this.fakeScreen = JGlasspaneMessage.this.parent.takeScreenshot();
            JGlasspaneMessage.this.centerWindow();
            JGlasspaneMessage.this.repaint();
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    };

    public JGlasspaneMessage(String row1, String row2, IDoScreenshot parent) {
        this.setLayout(null);
        this.setOpaque(false);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mousemotionListener);
        this.addComponentListener(this.componentListener);
        this.fakeScreen = null;
        this.parent = parent;
        this.messagePane = new JMessagePane(row1, row2);
        this.add(this.messagePane);
    }

    public void showGlassPane() {
        this.fakeScreen = this.parent.takeScreenshot();
        this.centerWindow();
        this.setVisible(true);
    }

    public void centerWindow() {
        if (this.messagePane != null) {
            int panelwidth = this.getWidth();
            int panelheight = this.getHeight();
            int objwidth = this.messagePane.getWidth();
            int objheight = this.messagePane.getHeight();
            this.messagePane.setBounds((panelwidth - objwidth) / 2, (panelheight - objheight) / 2, objwidth, objheight);
        }
    }

    public void setFakeScreen(BufferedImage image) {
        this.fakeScreen = image;
    }

    public void setMessage(String row1, String row2) {
        this.messagePane.setMessage(row1, row2);
    }

    protected void paintComponent(Graphics g) {
        if (this.fakeScreen != null) {
            float[] my_kernel = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
            ConvolveOp op = new ConvolveOp(new Kernel(3, 3, my_kernel));
            BufferedImage img = op.filter(this.fakeScreen, null);
            g.drawImage(img, 0, 0, null);
        }
        Graphics2D g2d = (Graphics2D)g;
        float alpha = 0.1f;
        Color color = new Color(0.0f, 0.0f, 1.0f, alpha);
        g2d.setPaint(color);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

