/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.jtable.rowheader;

import exenne.components.jtable.rowheader.RowAnnotation;
import exenne.components.jtable.rowheader.RowHeaderCellData;
import exenne.components.jtable.rowheader.RowHeaderModel;
import exenne.components.jtable.rowheader.RunnableSuggestion;
import exenne.components.jtable.rowheader.implementation.JRowHeaderCellRenderer;
import exenne.components.jtable.rowheader.implementation.JSuggestionsPopup;
import exenne.components.jtable.rowheader.implementation.PhonyListSelectionModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class JTableRowHeader
extends JList {
    private static final Color DEFAULT_BACKGROUND = new Color(230, 230, 255);
    private static final int NR_OF_CHARS = 4;
    private JTable jtable;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            JList sourceList = (JList)e.getSource();
            if (sourceList != JTableRowHeader.this) {
                return;
            }
            int row = sourceList.locationToIndex(e.getPoint());
            if (row != -1) {
                RowHeaderCellData rowHeaderCellData = (RowHeaderCellData)sourceList.getModel().getElementAt(row);
                JComponent renderedComponent = (JComponent)sourceList.getCellRenderer().getListCellRendererComponent(sourceList, rowHeaderCellData, row, false, false);
                Insets borderInsets = renderedComponent.getBorder().getBorderInsets(renderedComponent);
                Rectangle cellBounds = sourceList.getCellBounds(row, row);
                double offsetRight = cellBounds.getX() + cellBounds.getWidth() - (double)e.getX();
                if (rowHeaderCellData.getRowAnnotationCount() > 1 && offsetRight < (double)borderInsets.right) {
                    JTableRowHeader.this.doActionCycleAnnotations(row);
                    return;
                }
            } else {
                return;
            }
            JTableRowHeader.this.showSuggestionsForRow(row);
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            JList sourceList = (JList)e.getSource();
            if (sourceList != JTableRowHeader.this) {
                return;
            }
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            JTableRowHeader.this.showTooltipForRow(row);
        }
    };

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel) {
        this(jtable, listModel, 4);
    }

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel, int cols) {
        this.jtable = jtable;
        this.setSelectionModel(new PhonyListSelectionModel());
        this.setFixedCellHeight(jtable.getRowHeight());
        jtable.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            public void componentMoved(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            public void componentShown(ComponentEvent e) {
                JTableRowHeader.this.checkForHeightChange();
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        int charSize = this.getFontMetrics(this.getFont()).charWidth('0');
        this.setFixedCellWidth(charSize * cols);
        this.setModel(listModel);
        this.setCellRenderer(new JRowHeaderCellRenderer());
        this.setBackground(DEFAULT_BACKGROUND);
        this.addMouseListener(this.mouseListener);
    }

    private void checkForHeightChange() {
        int rowHeight = this.jtable.getRowHeight();
        if (rowHeight != this.getFixedCellHeight()) {
            this.setFixedCellHeight(rowHeight);
        }
    }

    public void paint(Graphics g) {
        this.checkForHeightChange();
        super.paint(g);
    }

    private void showSuggestionsForRow(int row) {
        Vector<RunnableSuggestion> suggestions;
        Rectangle cellBounds = this.getCellBounds(row, row);
        int popupX = (int)(cellBounds.getX() + cellBounds.getWidth() + 5.0);
        int popupY = (int)(cellBounds.getY() + cellBounds.getHeight());
        RowHeaderCellData cellData = (RowHeaderCellData)this.getModel().getElementAt(row);
        RowAnnotation currentAnnotation = cellData.getCurrentAnnotation();
        if (currentAnnotation != null && (suggestions = currentAnnotation.getSuggestions()) != null && !suggestions.isEmpty()) {
            JSuggestionsPopup suggestionsPopup = new JSuggestionsPopup(suggestions);
            suggestionsPopup.show(this, popupX, popupY);
        }
    }

    private void showTooltipForRow(int row) {
        final JTableRowHeader sourceList = this;
        Rectangle cellBounds = sourceList.getCellBounds(row, row);
        final int middleX = (int)(cellBounds.getX() + cellBounds.getWidth() / 2.0);
        final int middleY = (int)(cellBounds.getY() + cellBounds.getHeight() / 2.0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseEvent moveEvent = new MouseEvent(sourceList, 0, 0L, 0, middleX, middleY, 0, false);
                int initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().mouseMoved(moveEvent);
                ToolTipManager.sharedInstance().setInitialDelay(initialDelay);
            }
        });
    }

    private void doActionCycleAnnotations(int row) {
        RowHeaderModel rowModel = (RowHeaderModel)this.getModel();
        rowModel.cycleAnnotations(row);
    }
}

