/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.tree.search;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardNodeTraversal
implements Enumeration<DefaultMutableTreeNode> {
    private DefaultMutableTreeNode targetNode;
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode nextNode;
    boolean includeHead;

    public ForwardNodeTraversal(DefaultMutableTreeNode targetNode) {
        this(targetNode, true);
    }

    public ForwardNodeTraversal(DefaultMutableTreeNode targetNode, boolean includeHead) {
        this.targetNode = targetNode;
        this.currentNode = null;
        this.nextNode = this.computeNextElement(targetNode);
        this.includeHead = includeHead;
    }

    private DefaultMutableTreeNode getNextSubsrootedSibling(DefaultMutableTreeNode currentNode) {
        if (currentNode == null) {
            return null;
        }
        DefaultMutableTreeNode nextSibling = currentNode.getNextSibling();
        if (nextSibling != null) {
            return nextSibling;
        }
        return this.getNextSubsrootedSibling((DefaultMutableTreeNode)currentNode.getParent());
    }

    private DefaultMutableTreeNode computeNextElement(DefaultMutableTreeNode currentNode) {
        if (currentNode.getChildCount() != 0) {
            return (DefaultMutableTreeNode)currentNode.getFirstChild();
        }
        DefaultMutableTreeNode nextRootSibling = this.getNextSubsrootedSibling(currentNode);
        if (nextRootSibling != null) {
            return nextRootSibling;
        }
        return (DefaultMutableTreeNode)currentNode.getRoot();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.nextNode != null) {
            return !(this.includeHead ? this.targetNode.equals(this.currentNode) : this.targetNode.equals(this.nextNode));
        }
        return false;
    }

    @Override
    public DefaultMutableTreeNode nextElement() {
        if (this.hasMoreElements()) {
            this.currentNode = this.nextNode;
            this.nextNode = this.computeNextElement(this.currentNode);
            return this.currentNode;
        }
        throw new NoSuchElementException("No more nodes");
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("child1");
        DefaultMutableTreeNode child1_1 = new DefaultMutableTreeNode("child1_1");
        DefaultMutableTreeNode child1_2 = new DefaultMutableTreeNode("child1_2");
        DefaultMutableTreeNode child1_3 = new DefaultMutableTreeNode("child1_3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("child2");
        DefaultMutableTreeNode child2_1 = new DefaultMutableTreeNode("child2_1");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("child3");
        DefaultMutableTreeNode child3_1 = new DefaultMutableTreeNode("child3_1");
        DefaultMutableTreeNode child3_2 = new DefaultMutableTreeNode("child3_2");
        rootNode.add(child1);
        child1.add(child1_1);
        child1.add(child1_2);
        child1.add(child1_3);
        rootNode.add(child2);
        child2.add(child2_1);
        rootNode.add(child3);
        child3.add(child3_1);
        child3.add(child3_2);
        ForwardNodeTraversal nodeTraversal = new ForwardNodeTraversal(rootNode);
        while (nodeTraversal.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)nodeTraversal.nextElement();
            String item = (String)defaultMutableTreeNode.getUserObject();
            System.out.println(item);
        }
    }
}

