/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.test;

import exenne.components.textfield.utils.SincronizationDocumentListener;
import exenne.components.textfield.validator.IValidateString;
import exenne.components.textfield.validator.JValidatorTextfield;
import exenne.components.treetable.SelfManagedComponent;
import exenne.components.treetable.Treetable;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;

public class DoubleValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private MaterialFrahtPanel editingComp = new MaterialFrahtPanel();
    protected int clickCountToStart = 1;

    public DoubleValueCellEditor() {
        this.editingComp.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    public boolean stopCellEditing() {
        if (this.editingComp.isValidValue()) {
            return super.stopCellEditing();
        }
        return false;
    }

    public Object getCellEditorValue() {
        return this.editingComp.getValue();
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    public boolean isCellEditable(EventObject e) {
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Treetable treetable = (Treetable)table;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treetable.getValueAt(row, 0);
        this.editingComp.setValue((BigDecimal)value, BigDecimal.TEN);
        this.editingComp.prepareForDisplay();
        return this.editingComp;
    }

    private static class MaterialFrahtPanel
    extends JPanel
    implements SelfManagedComponent,
    IValidateString {
        public static final String UPDATE_BOUNDS = "UpdateBounds";
        private BigDecimal value = BigDecimal.ZERO;
        private BigDecimal fraht = BigDecimal.ZERO;
        private final Color bgColor = new Color(235, 235, 255);
        JPanel panel1;
        private JExposedValidatorTextfield fieldPu;
        private JLabel textPu;
        JPanel panel2;
        private JValidatorTextfield fieldMat;
        private JLabel textMat;
        JPanel panel3;
        private JLabel valFraht;
        private JLabel textFraht;
        DocumentListener documentListener1;
        DocumentListener documentListener2;

        public MaterialFrahtPanel() {
            this.setLayout(new GridLayout(3, 1, 0, 0));
            this.setBackground(this.bgColor);
            this.setFocusable(true);
            this.documentListener1 = new SincronizationDocumentListener(){

                public void sinc(String value) {
                    BigDecimal big = BigDecimal.ZERO;
                    try {
                        big = new BigDecimal(value);
                        big = big.add(MaterialFrahtPanel.this.fraht.negate());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MaterialFrahtPanel.this.fieldMat.getDocument().removeDocumentListener(MaterialFrahtPanel.this.documentListener2);
                    MaterialFrahtPanel.this.fieldMat.setText(big.stripTrailingZeros().toPlainString());
                    MaterialFrahtPanel.this.fieldMat.setCaretPosition(0);
                    MaterialFrahtPanel.this.fieldMat.getDocument().addDocumentListener(MaterialFrahtPanel.this.documentListener2);
                }
            };
            this.documentListener2 = new SincronizationDocumentListener(){

                public void sinc(String value) {
                    BigDecimal big = BigDecimal.ZERO;
                    try {
                        big = new BigDecimal(value);
                        big = big.add(MaterialFrahtPanel.this.fraht);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MaterialFrahtPanel.this.fieldPu.getDocument().removeDocumentListener(MaterialFrahtPanel.this.documentListener1);
                    MaterialFrahtPanel.this.fieldPu.setText(big.stripTrailingZeros().toPlainString());
                    MaterialFrahtPanel.this.fieldPu.setCaretPosition(0);
                    MaterialFrahtPanel.this.fieldPu.getDocument().addDocumentListener(MaterialFrahtPanel.this.documentListener1);
                }
            };
            this.panel1 = new JPanel();
            this.panel1.setBackground(this.bgColor);
            this.panel1.setLayout(new BoxLayout(this.panel1, 0));
            this.fieldPu = new JExposedValidatorTextfield();
            this.fieldPu.setHorizontalAlignment(4);
            this.fieldPu.getDocument().addDocumentListener(this.documentListener1);
            this.fieldPu.setValidator(this);
            this.textPu = new JLabel("(A) =");
            this.textPu.setBackground(this.bgColor);
            this.panel1.add(this.fieldPu);
            this.panel1.add(Box.createHorizontalGlue());
            this.panel1.add(this.textPu);
            this.panel2 = new JPanel();
            this.panel2.setBackground(this.bgColor);
            this.panel2.setLayout(new BoxLayout(this.panel2, 0));
            this.fieldMat = new JValidatorTextfield();
            this.fieldMat.setHorizontalAlignment(4);
            this.fieldMat.getDocument().addDocumentListener(this.documentListener2);
            this.fieldMat.setValidator(this);
            this.textMat = new JLabel("(B) +");
            this.textMat.setBackground(this.bgColor);
            this.panel2.add(this.fieldMat);
            this.panel2.add(Box.createHorizontalGlue());
            this.panel2.add(this.textMat);
            this.panel3 = new JPanel();
            this.panel3.setBackground(this.bgColor);
            this.panel3.setLayout(new BoxLayout(this.panel3, 0));
            this.valFraht = new JLabel("C");
            this.valFraht.setBackground(this.bgColor);
            this.valFraht.setHorizontalAlignment(4);
            this.textFraht = new JLabel("(C).");
            this.textFraht.setBackground(this.bgColor);
            this.panel3.add(this.valFraht);
            this.panel3.add(Box.createHorizontalGlue());
            this.panel3.add(this.textFraht);
            this.add(this.panel1);
            this.add(this.panel2);
            this.add(this.panel3);
            this.setOpaque(true);
        }

        public BigDecimal getValue() {
            return new BigDecimal(this.fieldPu.getText());
        }

        public void setValue(BigDecimal value, BigDecimal fraht) {
            this.fraht = fraht;
            this.value = value;
            this.valFraht.setText(fraht.stripTrailingZeros().toPlainString());
            this.fieldPu.setText(value.stripTrailingZeros().toPlainString());
            this.fieldPu.setCaretPosition(0);
        }

        public void setBounds(int x, int y, int width, int height) {
            if (Boolean.TRUE.equals(this.getClientProperty(UPDATE_BOUNDS))) {
                super.setBounds(x, y, width, height);
            }
        }

        public void updateBounds(Rectangle cellRect) {
            this.panel1.setPreferredSize(new Dimension(2 * cellRect.width, cellRect.height));
            this.fieldPu.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.textPu.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.panel2.setPreferredSize(new Dimension(2 * cellRect.width, cellRect.height));
            this.fieldMat.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.textMat.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.panel3.setPreferredSize(new Dimension(2 * cellRect.width, cellRect.height));
            this.valFraht.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.textFraht.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.setPreferredSize(new Dimension(2 * cellRect.width, 3 * cellRect.height + 8));
            this.putClientProperty(UPDATE_BOUNDS, Boolean.TRUE);
            this.setBounds(cellRect.x - 2, cellRect.y - 2, 2 * cellRect.width + 4, 3 * cellRect.height + 8);
            this.putClientProperty(UPDATE_BOUNDS, Boolean.FALSE);
            this.validate();
        }

        public boolean isValidValue() {
            return this.fieldPu.isValidValue() && this.fieldMat.isValidValue();
        }

        public boolean validate(String text) {
            return NumberUtils.isValidNumber(text);
        }

        public void prepareForDisplay() {
            this.fieldPu.setCaretPosition(0);
            this.fieldPu.selectAll();
            this.fieldPu.requestFocusInWindow();
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return this.fieldPu.processKeyBinding(ks, e, condition, pressed);
        }

        private static class JExposedValidatorTextfield
        extends JValidatorTextfield {
            public JExposedValidatorTextfield(IValidateString validator, Border originalBorder) {
                super(validator, originalBorder);
            }

            public JExposedValidatorTextfield(Border originalBorder) {
                super(originalBorder);
            }

            public JExposedValidatorTextfield() {
            }

            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        }
    }
}

