/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem;

import exenne.components.undosystem.EnsureComponentVisibleEdit;
import exenne.components.undosystem.ICanBeVisible;
import exenne.components.undosystem.UndoStateListener;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class GlobalUndoManager
extends UndoManager
implements UndoableEditListener {
    private Vector<UndoStateListener> undoStateListeners;

    public GlobalUndoManager() {
        this(10);
    }

    public GlobalUndoManager(int capacity) {
        this.setLimit(capacity);
        this.undoStateListeners = new Vector();
    }

    public synchronized UndoableEdit[] getEdits() {
        Object[] array = new UndoableEdit[this.edits.size()];
        this.edits.copyInto(array);
        return array;
    }

    public synchronized UndoableEdit[] getUndoableEdits() {
        int size = this.edits.size();
        Vector<UndoableEdit> v = new Vector<UndoableEdit>(size);
        for (int i = size - 1; i >= 0; --i) {
            UndoableEdit u = (UndoableEdit)this.edits.elementAt(i);
            if (!u.canUndo() || !u.isSignificant()) continue;
            v.addElement(u);
        }
        Object[] array = new UndoableEdit[v.size()];
        v.copyInto(array);
        return array;
    }

    public synchronized UndoableEdit[] getRedoableEdits() {
        int size = this.edits.size();
        Vector<UndoableEdit> v = new Vector<UndoableEdit>(size);
        for (int i = 0; i < size; ++i) {
            UndoableEdit u = (UndoableEdit)this.edits.elementAt(i);
            if (!u.canRedo() || !u.isSignificant()) continue;
            v.addElement(u);
        }
        Object[] array = new UndoableEdit[v.size()];
        v.copyInto(array);
        return array;
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean b = super.addEdit(anEdit);
        this.notifyStateListeners();
        return b;
    }

    public synchronized void undoableEditHappened(UndoableEditEvent ev) {
        UndoableEdit undoableEdit;
        Object source = ev.getSource();
        if (source instanceof ICanBeVisible && ev.getEdit().isSignificant()) {
            ICanBeVisible visibleComponent = (ICanBeVisible)source;
            undoableEdit = new EnsureComponentVisibleEdit(visibleComponent, ev.getEdit());
        } else {
            undoableEdit = ev.getEdit();
        }
        this.addEdit(undoableEdit);
    }

    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.notifyStateListeners();
    }

    public synchronized void redo() throws CannotUndoException {
        super.redo();
        this.notifyStateListeners();
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        super.undoOrRedo();
        this.notifyStateListeners();
    }

    protected UndoableEdit editToBeUndone() {
        return super.editToBeUndone();
    }

    protected UndoableEdit editToBeRedone() {
        UndoableEdit edit;
        UndoableEdit suggestedEdit = super.editToBeRedone();
        int suggestedEditIndex = this.edits.indexOf(suggestedEdit);
        UndoableEdit nextInsignificantEdit = null;
        int count = this.edits.size();
        int i = suggestedEditIndex + 1;
        while (i < count && !(edit = (UndoableEdit)this.edits.elementAt(i++)).isSignificant()) {
            nextInsignificantEdit = edit;
        }
        if (nextInsignificantEdit != null) {
            return nextInsignificantEdit;
        }
        return suggestedEdit;
    }

    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        super.undoTo(edit);
        this.notifyStateListeners();
    }

    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        super.redoTo(edit);
        this.notifyStateListeners();
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.notifyStateListeners();
    }

    public synchronized void discardEditsRelatedTo(Container c) {
        Enumeration cursor = this.edits.elements();
        while (cursor.hasMoreElements()) {
            Component editComponent;
            EnsureComponentVisibleEdit ensureEdit;
            ICanBeVisible editSource;
            UndoableEdit e = (UndoableEdit)cursor.nextElement();
            if (!(e instanceof EnsureComponentVisibleEdit) || !((editSource = (ensureEdit = (EnsureComponentVisibleEdit)e).getComponent()) instanceof Component) || !c.isAncestorOf(editComponent = (Component)((Object)editSource))) continue;
            ensureEdit.die();
        }
        this.notifyStateListeners();
    }

    public synchronized void addUndoStateListener(UndoStateListener l) {
        this.undoStateListeners.add(l);
    }

    public synchronized void removeUndoStateListener(UndoStateListener l) {
        this.undoStateListeners.remove(l);
    }

    private void notifyStateListeners() {
        for (UndoStateListener undoStateListener : this.undoStateListeners) {
            undoStateListener.undoStateChanged();
        }
    }
}

