/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem.tutorial;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class SampleUndoableEdit
extends AbstractUndoableEdit {
    private boolean isSignificant;
    private boolean isReplacer;
    private int number;
    private boolean allowAdds;
    private Vector addedEdits;
    private UndoableEdit replaced;

    public SampleUndoableEdit(int number, boolean allowAdds, boolean isSignificant, boolean isReplacer) {
        this.number = number;
        this.allowAdds = allowAdds;
        if (allowAdds) {
            this.addedEdits = new Vector();
        }
        this.isSignificant = isSignificant;
        this.isReplacer = isReplacer;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        System.out.print("Undo " + this.number);
        this.dumpState();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        System.out.print("Redo " + this.number);
        this.dumpState();
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (this.allowAdds) {
            this.addedEdits.addElement(anEdit);
            return true;
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        if (this.isReplacer) {
            this.replaced = anEdit;
            return true;
        }
        return false;
    }

    public boolean isSignificant() {
        return this.isSignificant;
    }

    public String toString() {
        return "<" + this.number + ">";
    }

    public void dumpState() {
        if (this.allowAdds && this.addedEdits.size() > 0) {
            Enumeration e = this.addedEdits.elements();
            System.out.print(" (absorbed: ");
            while (e.hasMoreElements()) {
                System.out.print(e.nextElement());
            }
            System.out.print(")");
        }
        if (this.isReplacer && this.replaced != null) {
            System.out.print(" (replaced: " + this.replaced + ")");
        }
        System.out.println();
    }
}

