/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public final class QueueUtilities {
    private static ReferenceQueue activeReferenceQueue;

    private QueueUtilities() {
    }

    public static synchronized ReferenceQueue activeReferenceQueue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new ActiveQueue(false);
        }
        return activeReferenceQueue;
    }

    private static final class ActiveQueue
    extends ReferenceQueue
    implements Runnable {
        private boolean running;
        private boolean deprecated;

        public ActiveQueue(boolean deprecated) {
            this.deprecated = deprecated;
            Thread t = new Thread((Runnable)this, "Active Reference Queue Daemon");
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
        }

        public Reference poll() {
            throw new UnsupportedOperationException();
        }

        public Reference remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        public Reference remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ActiveQueue activeQueue = this;
            synchronized (activeQueue) {
                if (this.running) {
                    return;
                }
                this.running = true;
            }
            while (true) {
                try {
                    while (true) {
                        Reference ref;
                        if (!((ref = super.remove(0L)) instanceof Runnable)) {
                            continue;
                        }
                        if (this.deprecated) {
                            // empty if block
                        }
                        try {
                            ((Runnable)((Object)ref)).run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {}
                        continue;
                        finally {
                            ref = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

