/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.HashSet;
import java.util.Iterator;
import org.openide.util.TaskListener;

public class Task
implements Runnable {
    public static final Task EMPTY = new Task();
    private Runnable run;
    private boolean finished;
    private HashSet list;

    public Task(Runnable run) {
        this.run = run;
        if (run == null) {
            this.finished = true;
        }
    }

    protected Task() {
    }

    public final boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished() {
        Task task = this;
        synchronized (task) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyRunning() {
        Task task = this;
        synchronized (task) {
            this.finished = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyFinished() {
        Iterator it;
        Task task = this;
        synchronized (task) {
            this.finished = true;
            this.notifyAll();
            if (this.list == null) {
                return;
            }
            it = ((HashSet)this.list.clone()).iterator();
        }
        while (it.hasNext()) {
            TaskListener l = (TaskListener)it.next();
            l.taskFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.notifyRunning();
            if (this.run != null) {
                this.run.run();
            }
        }
        finally {
            this.notifyFinished();
        }
    }

    public synchronized void addTaskListener(TaskListener l) {
        if (this.list == null) {
            this.list = new HashSet();
        }
        this.list.add(l);
        if (this.finished) {
            l.taskFinished(this);
        }
    }

    public synchronized void removeTaskListener(TaskListener l) {
        if (this.list == null) {
            return;
        }
        this.list.remove(l);
    }

    public String toString() {
        return "task " + this.run;
    }

    String debug() {
        return this.run == null ? "null" : this.run.getClass().getName();
    }

    static {
        Task.EMPTY.finished = true;
    }
}

