/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.popup;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class JConfigurableMenu
extends JMenu {
    public ActionListener myPopupListener = null;
    Hashtable<String, Component> items;

    public JConfigurableMenu(String name, Icon icon, ActionListener popupListener) {
        super(name);
        this.setIcon(icon);
        this.items = new Hashtable();
        this.myPopupListener = popupListener;
    }

    public JConfigurableMenu(String name, ActionListener popupListener) {
        this(name, null, popupListener);
    }

    public void addItem(String itemName, Icon icon) {
        JMenuItem menuItem = new JMenuItem(itemName);
        menuItem.setIcon(icon);
        menuItem.setActionCommand(itemName.toLowerCase());
        menuItem.addActionListener(this.myPopupListener);
        this.items.put(itemName, menuItem);
        this.add(menuItem);
    }

    public void addItem(String itemName) {
        this.addItem(itemName, null);
    }

    public void setItemEnabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(true);
        }
    }

    public void setItemDisabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(false);
        }
    }

    public void setItemVisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(true);
        }
    }

    public void setItemInvisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(false);
        }
    }
}

