/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.cellrenderers;

import exenne.components.treetable.JHandleIcons;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.TreetableModel;
import exenne.components.treetable.cellrenderers.ExpansionHandleBorder;
import exenne.components.utils.GraphicRenderingUtils;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreetableCellRenderer
extends DefaultTableCellRenderer {
    private Treetable treetable = null;
    private TreetableModel treetableModel = null;
    private AbstractLayoutCache layoutCache = null;
    private RenderDataProvider renderDataProvider = null;
    private RowModel rowModel = null;
    private boolean isSelected = false;
    private boolean hasSomeFocus = false;
    private boolean isCellEditable = false;
    private boolean isLeaf = true;
    private boolean isFirstColumn = false;
    private boolean isLastColumn = false;
    private boolean isExpanded = false;
    private boolean isCellImportant = false;
    private boolean isLeftCellImportant = false;
    private boolean isRightCellImportant = false;
    private boolean isShowHandle = false;
    private boolean isGrouping = false;
    private boolean hasToolTipText = false;
    private int nestingDepth = 0;
    private Color prefferedBackground = null;
    private Color prefferedForeground = null;
    private Hashtable<Integer, Boolean> hashtableIsLast;
    private Hashtable<Integer, Color> hashtableParentColor;
    private Border expansionBorder = new ExpansionHandleBorder();
    private JHandleIcons iconProvider = JHandleIcons.getInstance();

    public AbstractTreetableCellRenderer() {
        this.hashtableParentColor = new Hashtable();
        this.hashtableIsLast = new Hashtable();
    }

    @Override
    public void setBorder(Border b) {
        if (b == this.expansionBorder) {
            super.setBorder(b);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(this.expansionBorder, b));
        }
    }

    public AbstractLayoutCache getLayoutCache() {
        return this.layoutCache;
    }

    public RenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public Treetable getTreetable() {
        return this.treetable;
    }

    public TreetableModel getTreetableModel() {
        return this.treetableModel;
    }

    public RowModel getRowModel() {
        return this.rowModel;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public Icon getExpandedIcon() {
        return this.iconProvider.getIcon(1);
    }

    public Icon getCollapsedIcon() {
        return this.iconProvider.getIcon(0);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean hasSomeFocus() {
        return this.hasSomeFocus;
    }

    public boolean isCellEditable() {
        return this.isCellEditable;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isFirstColumn() {
        return this.isFirstColumn;
    }

    public boolean isLastColumn() {
        return this.isLastColumn;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isCellImportant() {
        return this.isCellImportant;
    }

    public boolean isLeftCellImportant() {
        return this.isLeftCellImportant;
    }

    public boolean isRightCellImportant() {
        return this.isRightCellImportant;
    }

    public boolean isShowHandle() {
        return this.isShowHandle;
    }

    public boolean isGrouping() {
        return this.isGrouping;
    }

    public boolean hasToolTipText() {
        return this.hasToolTipText;
    }

    public int getNestingWidth() {
        return this.getExpansionHandleWidth();
    }

    public int getExpansionHandleWidth() {
        return this.getExpandedIcon().getIconWidth();
    }

    public int getExpansionHandleHeight() {
        return this.getExpandedIcon().getIconHeight();
    }

    public int getNestingDepth() {
        return this.nestingDepth;
    }

    public Color getPrefferedBackground() {
        return this.prefferedBackground;
    }

    public Color getPrefferedForeground() {
        return this.prefferedForeground;
    }

    public Hashtable<Integer, Color> getHashtableParentColor() {
        return this.hashtableParentColor;
    }

    public Hashtable<Integer, Boolean> getHashtableIsLast() {
        return this.hashtableIsLast;
    }

    protected void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setHasSomeFocus(boolean hasSomeFocus) {
        this.hasSomeFocus = hasSomeFocus;
    }

    protected void setIsCellEditable(boolean isCellEditable) {
        this.isCellEditable = isCellEditable;
    }

    protected void setIsLeaf(boolean val) {
        this.isLeaf = val;
    }

    protected void setIsFirstColumn(boolean isFirstColumn) {
        this.isFirstColumn = isFirstColumn;
    }

    protected void setIsLastColumn(boolean isLastColumn) {
        this.isLastColumn = isLastColumn;
    }

    protected void setIsExpanded(boolean val) {
        this.isExpanded = val;
    }

    protected void setIsCellImportant(boolean isCellImportant) {
        this.isCellImportant = isCellImportant;
    }

    protected void setIsLeftCellImportant(boolean isLeftCellImportant) {
        this.isLeftCellImportant = isLeftCellImportant;
    }

    protected void setIsRightCellImportant(boolean isRightCellImportant) {
        this.isRightCellImportant = isRightCellImportant;
    }

    protected void setIsShowHandle(boolean val) {
        this.isShowHandle = val;
    }

    protected void setIsGrouping(boolean isGrouping) {
        this.isGrouping = isGrouping;
    }

    protected void setHasToolTipText(boolean hasToolTipText) {
        this.hasToolTipText = hasToolTipText;
    }

    protected void setNestingDepth(int i) {
        this.nestingDepth = i;
    }

    protected void setPrefferedBackground(Color prefferedBackground) {
        this.prefferedBackground = prefferedBackground;
    }

    protected void setPrefferedForeground(Color prefferedForeground) {
        this.prefferedForeground = prefferedForeground;
    }

    protected void setHashtableParentColor(Hashtable<Integer, Color> hashtableParentColor) {
        this.hashtableParentColor = hashtableParentColor;
    }

    protected void setHashtableIsLast(Hashtable<Integer, Boolean> hashtableIsLast) {
        this.hashtableIsLast = hashtableIsLast;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.treetable = (Treetable)table;
        this.treetableModel = this.treetable.getTreetableModel();
        this.layoutCache = this.treetable.getLayoutCache();
        this.renderDataProvider = this.treetable.getRenderDataProvider();
        if (this.renderDataProvider == null) {
            this.setText("no renderDataProvider");
            return this;
        }
        this.rowModel = this.treetableModel.getRowModel();
        DefaultMutableTreeNode indexColumnNode = (DefaultMutableTreeNode)this.treetableModel.getValueAt(row, 0);
        this.isSelected = isSelected;
        this.hasSomeFocus = hasFocus;
        this.isCellEditable = this.treetableModel.isCellEditable(row, column);
        this.isLeaf = this.treetable.getTreetableModel().isLeaf(indexColumnNode);
        this.isFirstColumn = this.treetable.isTreeColumnIndex(column);
        this.isLastColumn = column == this.treetableModel.getColumnCount() - 1;
        TreePath path = this.layoutCache.getPathForRow(row);
        this.isExpanded = this.layoutCache.isExpanded(path);
        this.nestingDepth = path.getPathCount() - 1;
        if (this.isFirstColumn) {
            this.isCellImportant = true;
            this.isLeftCellImportant = false;
            this.isRightCellImportant = this.rowModel.isCellImportant(indexColumnNode, this.isExpanded, 0);
        } else {
            this.isCellImportant = this.rowModel.isCellImportant(indexColumnNode, this.isExpanded, column - 1);
            this.isLeftCellImportant = column == 1 ? true : this.rowModel.isCellImportant(indexColumnNode, this.isExpanded, column - 2);
            this.isRightCellImportant = this.isLastColumn ? false : this.rowModel.isCellImportant(indexColumnNode, this.isExpanded, column);
        }
        this.isShowHandle = this.isFirstColumn;
        this.isGrouping = this.renderDataProvider.isGrouping(indexColumnNode);
        String overwriteString = null;
        if (this.isFirstColumn) {
            String displayName = this.renderDataProvider.getDisplayName(indexColumnNode);
            if (displayName != null) {
                this.setText(displayName);
            }
        } else {
            overwriteString = this.rowModel.getOverwriteString(indexColumnNode, this.isExpanded, column - 1);
            if (overwriteString != null) {
                value = overwriteString;
            }
            if (value instanceof String) {
                this.setText((String)value);
            } else if (value instanceof BigDecimal) {
                BigDecimal auxBigDecimal = (BigDecimal)value;
                this.setText(NumberUtils.formatBigDecimal(auxBigDecimal, this.renderDataProvider.getDecimalScale()));
            } else if (value instanceof Double) {
                Double auxDouble = (Double)value;
                this.setText(NumberUtils.formatDouble(auxDouble, this.renderDataProvider.getDecimalScale()));
            } else if (value instanceof Integer) {
                Integer auxInteger = (Integer)value;
                this.setText(NumberUtils.formatInteger(auxInteger));
            }
        }
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
        } else if (overwriteString != null) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(2);
        }
        String tooltipText = this.isFirstColumn ? this.renderDataProvider.getTooltipText(indexColumnNode) : this.rowModel.getTooltipTextFor(indexColumnNode, column - 1);
        this.setToolTipText(tooltipText);
        this.hasToolTipText = tooltipText != null;
        Color overwriteBackground = null;
        Color overwriteForeground = null;
        if (!this.isFirstColumn) {
            overwriteBackground = this.rowModel.getOverwriteBackground(indexColumnNode, this.isExpanded, column - 1);
            overwriteForeground = this.rowModel.getOverwriteForeground(indexColumnNode, this.isExpanded, column - 1);
        }
        this.prefferedBackground = this.renderDataProvider.getBackground(indexColumnNode);
        this.prefferedForeground = this.renderDataProvider.getForeground(indexColumnNode);
        if (isSelected) {
            if (overwriteBackground != null) {
                this.setBackground(GraphicRenderingUtils.colorShift(this.treetable.getSelectionBackground(), overwriteBackground));
            } else {
                this.setBackground(this.treetable.getSelectionBackground());
            }
            if (overwriteForeground != null) {
                this.setForeground(GraphicRenderingUtils.colorShift(this.treetable.getSelectionForeground(), overwriteForeground));
            } else {
                this.setForeground(this.treetable.getSelectionForeground());
            }
        } else if (this.isGrouping) {
            if (overwriteBackground != null) {
                this.setBackground(overwriteBackground);
            } else {
                this.setBackground(Color.WHITE);
            }
            if (overwriteForeground != null) {
                this.setForeground(overwriteForeground);
            } else {
                this.setForeground(Color.BLACK);
            }
        } else {
            if (overwriteBackground != null) {
                this.setBackground(overwriteBackground);
            } else {
                this.setBackground(this.prefferedBackground);
            }
            if (overwriteForeground != null) {
                this.setForeground(overwriteForeground);
            } else {
                this.setForeground(this.prefferedForeground);
            }
        }
        if (this.isFirstColumn) {
            Icon icon = this.renderDataProvider.getIcon(indexColumnNode, this.isExpanded);
            if (icon == null) {
                if (!this.isLeaf) {
                    if (this.isExpanded) {
                        this.setIcon(this.getDefaultOpenIcon());
                    } else {
                        this.setIcon(this.getDefaultClosedIcon());
                    }
                } else {
                    this.setIcon(this.getDefaultLeafIcon());
                }
            } else {
                this.setIcon(icon);
            }
        } else {
            this.setIcon(null);
        }
        this.hashtableParentColor.clear();
        DefaultMutableTreeNode nod = indexColumnNode;
        block0: for (int i = this.nestingDepth - 1; i > 0; --i) {
            if (this.renderDataProvider.isGrouping(nod = (DefaultMutableTreeNode)nod.getParent())) {
                this.hashtableParentColor.put(i, this.renderDataProvider.getBackground(nod));
                continue;
            }
            int[] sels = this.treetable.getSelectedIndices();
            for (int j = 0; j < sels.length; ++j) {
                DefaultMutableTreeNode auxNod = (DefaultMutableTreeNode)this.treetable.getValueAt(sels[j], 0);
                if (!nod.equals(auxNod)) continue;
                this.hashtableParentColor.put(i, this.treetable.getSelectionBackground());
                continue block0;
            }
        }
        this.hashtableIsLast.clear();
        nod = indexColumnNode;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nod.getParent();
        boolean state = true;
        for (int i = this.nestingDepth - 1; i > 0; --i) {
            state = state && parent.getLastChild() == nod;
            this.hashtableIsLast.put(i, state);
            nod = parent;
            parent = (DefaultMutableTreeNode)nod.getParent();
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isSelected = " + this.isSelected);
        stringBuffer.append('\n');
        stringBuffer.append("hasSomeFocus = " + this.hasSomeFocus);
        stringBuffer.append('\n');
        stringBuffer.append("isCellEditable = " + this.isCellEditable);
        stringBuffer.append('\n');
        stringBuffer.append("isLeaf = " + this.isLeaf);
        stringBuffer.append('\n');
        stringBuffer.append("isFirstColumn = " + this.isFirstColumn);
        stringBuffer.append('\n');
        stringBuffer.append("isLastColumn = " + this.isLastColumn);
        stringBuffer.append('\n');
        stringBuffer.append("isCellImportant = " + this.isCellImportant);
        stringBuffer.append('\n');
        stringBuffer.append("isLeftCellImportant = " + this.isLeftCellImportant);
        stringBuffer.append('\n');
        stringBuffer.append("isRightCellImportant = " + this.isRightCellImportant);
        stringBuffer.append('\n');
        stringBuffer.append("isExpanded = " + this.isExpanded);
        stringBuffer.append('\n');
        stringBuffer.append("isShowHandle = " + this.isShowHandle);
        stringBuffer.append('\n');
        stringBuffer.append("isGrouping = " + this.isGrouping);
        stringBuffer.append('\n');
        stringBuffer.append("hasToolTipText = " + this.hasToolTipText);
        stringBuffer.append('\n');
        stringBuffer.append("text = " + this.getText());
        stringBuffer.append('\n');
        stringBuffer.append("nestingDepth = " + this.nestingDepth);
        stringBuffer.append('\n');
        stringBuffer.append("background = " + this.getBackground());
        stringBuffer.append('\n');
        stringBuffer.append("foreground = " + this.getForeground());
        stringBuffer.append('\n');
        stringBuffer.append("prefferedBackground = " + this.prefferedBackground);
        stringBuffer.append('\n');
        stringBuffer.append("prefferedForeground = " + this.prefferedForeground);
        stringBuffer.append('\n');
        stringBuffer.append("hashtableIsLast = " + this.hashtableIsLast);
        stringBuffer.append('\n');
        stringBuffer.append("hashtableParentColor = " + this.hashtableParentColor);
        stringBuffer.append('\n');
        stringBuffer.append("==========================");
        return stringBuffer.toString();
    }
}

