/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.undosupport;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class MultiplePropertyUndoableEdit
extends AbstractUndoableEdit {
    private ActionEvent someAction = new ActionEvent(this, 0, "MultiplePropertyUndoableEdit");
    private JColoredTable table;
    private AbstractTableModel tableModel;
    private int[] modelRows;
    private UndoableEdit controllerAction;
    private ActionListener actionListener;

    public MultiplePropertyUndoableEdit(JColoredTable table, int[] modelRows, UndoableEdit controllerAction, ActionListener actionListener) {
        this.table = table;
        this.modelRows = modelRows;
        this.controllerAction = controllerAction;
        this.actionListener = actionListener;
        AbstractColoredTableModel modelInterface = table.getModel();
        if (modelInterface instanceof AbstractTableModel) {
            this.tableModel = modelInterface;
        }
    }

    public void notifyTable() {
        this.notifyTableModel();
    }

    public void notifyListener() {
        this.notifyExternalListener();
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.controllerAction.undo();
        this.notifyActionPerformed();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.controllerAction.redo();
        this.notifyActionPerformed();
    }

    private void notifyTableModel() {
        if (this.tableModel != null) {
            for (int i = 0; i < this.modelRows.length; ++i) {
                int j = this.modelRows[i];
                this.tableModel.fireTableRowsUpdated(j, j);
            }
        }
    }

    private void notifyExternalListener() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(this.someAction);
        }
    }

    private void notifyActionPerformed() {
        this.notifyTableModel();
        if (this.table != null) {
            this.table.clearSelection();
            for (int i = 0; i < this.modelRows.length; ++i) {
                int modelRow = this.modelRows[i];
                int viewRow = this.table.convertRowIndexToView(modelRow);
                this.table.selectAndScrollToRow(viewRow);
            }
        }
        this.notifyExternalListener();
    }
}

