/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.jtable.rowheader;

import exenne.components.jtable.rowheader.RowHeaderCellData;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class RowHeaderModel
extends AbstractListModel
implements TableModelListener {
    private TableModel tabelModel;
    private HashMap<Integer, RowHeaderCellData> nodeCache;

    public RowHeaderModel(TableModel tabelModel) {
        this.tabelModel = tabelModel;
        tabelModel.addTableModelListener(this);
        this.nodeCache = new HashMap();
    }

    public int getSize() {
        return this.tabelModel.getRowCount();
    }

    public Object getElementAt(int i) {
        RowHeaderCellData value = this.nodeCache.get(i);
        if (value != null) {
            return value;
        }
        return this.getListCellData(this.tabelModel.getValueAt(i, 0));
    }

    public abstract RowHeaderCellData getListCellData(Object var1);

    public void tableChanged(TableModelEvent tme) {
        int type = tme.getType();
        switch (type) {
            case 1: {
                this.nodeCache.clear();
                this.fireIntervalAdded(tme.getSource(), tme.getFirstRow(), tme.getLastRow());
                break;
            }
            case -1: {
                this.nodeCache.clear();
                this.fireIntervalRemoved(tme.getSource(), tme.getFirstRow(), tme.getLastRow());
                break;
            }
            case 0: {
                this.nodeCache.clear();
                this.fireContentsChanged(tme.getSource(), tme.getFirstRow(), tme.getLastRow());
                break;
            }
        }
    }

    public void cycleAnnotations(int row) {
        RowHeaderCellData cellData = (RowHeaderCellData)this.getElementAt(row);
        if (cellData.cycleAnnotations()) {
            this.nodeCache.put(row, cellData);
            this.fireContentsChanged(this, row, row);
        }
    }
}

