/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.miscellaneous.infolines;

import exenne.components.miscellaneous.infolines.JInformationIcons;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JInformationLine
extends JPanel {
    public static final int TYPE_INFO = 0;
    public static final int TYPE_SEVERE = 1;
    Border panelBorder;
    JLabel labelInformatii;

    public JInformationLine(String message) {
        this(message, 0);
    }

    public JInformationLine(String message, int messageType) {
        this.setLayout(new BoxLayout(this, 0));
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        Border shadeBorder = BorderFactory.createEtchedBorder();
        this.panelBorder = BorderFactory.createCompoundBorder(shadeBorder, emptyBorder);
        this.setOpaque(true);
        this.labelInformatii = new JLabel(message);
        this.setShowBorder(true);
        this.setMessageType(messageType);
        this.add(this.labelInformatii);
        this.add(Box.createHorizontalGlue());
    }

    public void setMessage(String message) {
        this.labelInformatii.setText(message);
    }

    public void setMessageType(int messageType) {
        this.setBackground(JInformationLine.getBackgroundColor(messageType));
        this.setOpaque(true);
        this.labelInformatii.setIcon(JInformationLine.getIcon(messageType));
        this.labelInformatii.setBackground(JInformationLine.getBackgroundColor(messageType));
        this.labelInformatii.setForeground(JInformationLine.getForegroundColor(messageType));
    }

    public void setShowBorder(boolean shouldShowBorder) {
        if (shouldShowBorder) {
            this.setBorder(this.panelBorder);
        } else {
            this.setBorder(null);
        }
    }

    private static Color getBackgroundColor(int type) {
        switch (type) {
            case 0: {
                return Color.WHITE;
            }
            case 1: {
                return Color.WHITE;
            }
        }
        return null;
    }

    private static Color getForegroundColor(int type) {
        switch (type) {
            case 0: {
                return Color.BLUE;
            }
            case 1: {
                return Color.RED;
            }
        }
        return null;
    }

    private static Icon getIcon(int type) {
        switch (type) {
            case 0: {
                return JInformationIcons.INFO.getIcon();
            }
            case 1: {
                return JInformationIcons.SEVERE.getIcon();
            }
        }
        return JInformationIcons.INFO.getIcon();
    }
}

