/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel;

import exenne.components.propertiespanel.AbstractPropertiesPanelModel;
import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.propertiespanel.IPropertiesHeader;
import exenne.components.propertiespanel.IValidationProblemListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationPanel;

public class JPropertiesPanel
extends JPanel
implements ChangeListener {
    public static final int TEXTFIELD = 0;
    public static final int TEXTAREA = 1;
    private static final int PADDING_HEIGHT = 10;
    private static final int PADDING_TOP = 5;
    private static final int PADDING_LEFT = 5;
    private static final int PADDING_RIGHT = 4;
    private static final int PADDING_BOTTOM = 10;
    private static final int COMPONENTS_SPACER = 3;
    private AbstractPropertiesPanelModel propertiesModel;
    private Vector<IPropertiesEditor> propertiesEditorVector;
    private Vector<IValidationProblemListener> validationListeners;
    private Hashtable<Object, GridBagConstraints> gridBagConstraintsHash;
    private Vector<IEditorChangeListener> editorChangeListeners;
    private boolean[] changeTracker;
    private GridBagConstraints fillConstraint;
    private ValidationPanel validationPanel;
    private JPanel innerPanel;

    public JPropertiesPanel(AbstractPropertiesPanelModel propertiesModel) {
        this.setLayout(new BorderLayout());
        this.validationPanel = new ValidationPanel();
        this.changeTracker = null;
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 4));
        this.propertiesModel = propertiesModel;
        this.propertiesEditorVector = new Vector();
        this.validationListeners = new Vector();
        this.gridBagConstraintsHash = new Hashtable();
        this.editorChangeListeners = new Vector();
        this.computeGridBagConstraints();
        int labelWidth = propertiesModel.getLabelWidth();
        for (int i = 0; i < propertiesModel.getRowCount(); ++i) {
            if (propertiesModel.getHeaderComponentAt(i) != null) {
                IPropertiesHeader propertiesHeader = propertiesModel.getHeaderComponentAt(i);
                this.innerPanel.add((Component)propertiesHeader.getContainerComponent(), this.gridBagConstraintsHash.get(propertiesHeader));
            }
            IPropertiesEditor propertiesEditor = propertiesModel.getEditorComponentAt(i);
            Class objectClass = propertiesModel.getClassAt(i);
            Object objectValue = propertiesModel.getValueAt(i);
            int rowHeight = propertiesModel.getRowHeightAt(i);
            propertiesEditor.setValue(objectClass, objectValue);
            propertiesEditor.setEditorName(propertiesModel.getDescriptionAt(i));
            this.propertiesEditorVector.add(propertiesEditor);
            JPanel rowPanel = this.getPanelForRow(propertiesModel.getDescriptionAt(i), labelWidth, rowHeight, propertiesEditor.getContainerComponent());
            this.innerPanel.add((Component)rowPanel, this.gridBagConstraintsHash.get(propertiesEditor));
            Validator validator = propertiesModel.getValidatorAt(i);
            if (validator != null) {
                this.setValidatorForComponent(validator, propertiesEditor.getEditorComponent());
            }
            LocalEditorChangeListener editorChangeListener = new LocalEditorChangeListener(i);
            propertiesEditor.addEditorChangeListener(editorChangeListener);
            this.editorChangeListeners.add(editorChangeListener);
        }
        this.innerPanel.add(Box.createVerticalStrut(10), this.fillConstraint);
        this.validationPanel.setInnerComponent(this.innerPanel);
        this.add((Component)this.validationPanel, "Center");
        this.validationPanel.addChangeListener(this);
    }

    private void computeGridBagConstraints() {
        int maxCol = 1;
        int numCol = 0;
        int[] columnStats = new int[this.propertiesModel.getRowCount()];
        int lastRow = this.propertiesModel.getRowCount() - 1;
        int lastNewline = 0;
        for (int i = 0; i < this.propertiesModel.getRowCount(); ++i) {
            if (++numCol > maxCol) {
                maxCol = numCol;
            }
            if ((i == lastRow || !this.propertiesModel.isRowOnNewline(i + 1)) && i != lastRow) continue;
            for (int j = lastNewline; j <= i; ++j) {
                columnStats[j] = numCol;
            }
            numCol = 0;
            lastNewline = i + 1;
        }
        int countRow = -1;
        int countCols = 0;
        for (int i = 0; i < this.propertiesModel.getRowCount(); ++i) {
            if (this.propertiesModel.isRowOnNewline(i)) {
                ++countRow;
                countCols = 0;
            }
            if (this.propertiesModel.getHeaderComponentAt(i) != null) {
                GridBagConstraints elementConstraints = new GridBagConstraints();
                elementConstraints.fill = 2;
                elementConstraints.anchor = 21;
                elementConstraints.weightx = 1.0;
                elementConstraints.gridy = countRow++;
                elementConstraints.gridx = 0;
                elementConstraints.gridwidth = maxCol;
                this.gridBagConstraintsHash.put(this.propertiesModel.getHeaderComponentAt(i), elementConstraints);
            }
            int colsOnRow = columnStats[i];
            int gridsForCell = maxCol / colsOnRow;
            int rightLeftover = maxCol % colsOnRow;
            GridBagConstraints elementConstraints = new GridBagConstraints();
            elementConstraints.fill = 2;
            if (countCols == 0) {
                elementConstraints.anchor = 21;
            } else if (countCols == colsOnRow - 1) {
                elementConstraints.anchor = 22;
            }
            elementConstraints.weightx = (double)colsOnRow / (double)maxCol;
            elementConstraints.gridy = countRow;
            elementConstraints.gridx = countCols * gridsForCell;
            elementConstraints.gridwidth = gridsForCell;
            if (countCols == colsOnRow - 1) {
                elementConstraints.gridwidth += rightLeftover;
            }
            this.gridBagConstraintsHash.put(this.propertiesModel.getEditorComponentAt(i), elementConstraints);
            ++countCols;
        }
        ++countRow;
        this.fillConstraint = new GridBagConstraints();
        this.fillConstraint.fill = 1;
        this.fillConstraint.anchor = 21;
        this.fillConstraint.weightx = 1.0;
        this.fillConstraint.weighty = 1.0;
        this.fillConstraint.gridy = countRow;
        this.fillConstraint.gridx = 0;
        this.fillConstraint.gridwidth = maxCol;
    }

    private void setValidatorForComponent(Validator validator, JComponent editorComponent) {
        if (editorComponent instanceof JTextComponent) {
            this.validationPanel.getValidationGroup().add((JTextComponent)editorComponent, validator);
        } else if (editorComponent instanceof JComboBox) {
            this.validationPanel.getValidationGroup().add((JComboBox)editorComponent, validator);
        }
    }

    private JPanel getPanelForRow(String descriptionText, int labelWidth, int boxHeight, JComponent component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(3, boxHeight)));
        if (descriptionText != null) {
            JLabel descriptionLabel = new JLabel(descriptionText);
            descriptionLabel.setPreferredSize(new Dimension(labelWidth, 0));
            descriptionLabel.setMinimumSize(new Dimension(labelWidth, 0));
            panel.add(descriptionLabel);
        }
        panel.add(component);
        return panel;
    }

    public void addValidationProblemListener(IValidationProblemListener listener) {
        this.validationListeners.add(listener);
    }

    public void deleteValidationProblemListener(IValidationProblemListener listener) {
        this.validationListeners.remove(listener);
    }

    public void stateChanged(ChangeEvent e) {
        Problem problem = this.validationPanel.getProblem();
        for (IValidationProblemListener iValidationProblemListener : this.validationListeners) {
            iValidationProblemListener.validationProblemChanged(problem);
        }
    }

    public AbstractPropertiesPanelModel getModel() {
        return this.propertiesModel;
    }

    public boolean commitChanges() {
        boolean hasChanged = false;
        this.changeTracker = new boolean[this.propertiesModel.getRowCount()];
        for (int i = 0; i < this.propertiesModel.getRowCount(); ++i) {
            boolean auxBoolean;
            Class objectClass = this.propertiesModel.getClassAt(i);
            IPropertiesEditor editorComponent = this.propertiesEditorVector.get(i);
            Object newValue = editorComponent.getValue(objectClass);
            this.changeTracker[i] = auxBoolean = this.propertiesModel.setValueAt(i, newValue);
            hasChanged = auxBoolean || hasChanged;
        }
        return hasChanged;
    }

    public void resetToDefaults() {
        for (int i = 0; i < this.propertiesEditorVector.size(); ++i) {
            Object defaultValue = this.propertiesModel.getDefaultValueAt(i);
            if (defaultValue == null) continue;
            IPropertiesEditor propertiesEditor = this.propertiesEditorVector.elementAt(i);
            propertiesEditor.setValue(defaultValue.getClass(), defaultValue);
        }
    }

    public boolean hasRowChanged(int row) {
        if (this.changeTracker != null) {
            return this.changeTracker[row];
        }
        return false;
    }

    private void silenceAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.setEnabled(false);
        }
    }

    private void wakeupAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.setEnabled(true);
        }
    }

    private class LocalEditorChangeListener
    implements IEditorChangeListener {
        private int row;
        private boolean isEnabled;

        public LocalEditorChangeListener(int row) {
            this.row = row;
            this.isEnabled = true;
        }

        public void setEnabled(boolean shouldEnable) {
            this.isEnabled = shouldEnable;
        }

        public void fireValueChanged() {
            if (this.isEnabled) {
                JPropertiesPanel.this.silenceAllListeners();
                JPropertiesPanel.this.validationPanel.getValidationGroup().modifyComponents(new Runnable(){

                    public void run() {
                        JPropertiesPanel.this.propertiesModel.fireActionRowChanged(LocalEditorChangeListener.this.row);
                    }
                });
                JPropertiesPanel.this.wakeupAllListeners();
            }
        }
    }
}

