/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.filechooser.filters.ImageSpecificFileFilter;
import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.utils.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JImageChooserPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ActionListener {
    private final Frame rootFrame;
    private JLabel imageLabel;
    private JButton selectButton;
    private JFileChooser fileChooser;
    private BufferedImage storedImage;
    private int width;
    private int height;

    public JImageChooserPropertiesEditor(Frame rootFrame, int columns) {
        this(rootFrame, columns, 100, 100);
    }

    public JImageChooserPropertiesEditor(Frame rootFrame, int columns, int width, int height) {
        this.setLayout(new BorderLayout());
        this.storedImage = null;
        this.width = width;
        this.height = height;
        this.rootFrame = rootFrame;
        this.imageLabel = new JLabel("No image");
        this.imageLabel.setBorder(BorderFactory.createEtchedBorder());
        this.imageLabel.setHorizontalAlignment(4);
        this.imageLabel.setBackground(Color.WHITE);
        this.imageLabel.setOpaque(true);
        this.selectButton = new JButton("..");
        this.add((Component)this.imageLabel, "Center");
        this.add((Component)this.selectButton, "East");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new ImageSpecificFileFilter());
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.selectButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal = this.fileChooser.showOpenDialog(this.rootFrame);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                BufferedImage loadedImage = ImageIO.read(file);
                this.setImage(loadedImage);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    private void setImage(BufferedImage image) {
        this.storedImage = image;
        BufferedImage resizedIcon = ImageUtils.resizeImage(image, this.width, this.height);
        this.imageLabel.setText("");
        this.imageLabel.setIcon(new ImageIcon(resizedIcon));
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.imageLabel;
    }

    public void setEditorName(String name) {
        this.setName(name);
        this.imageLabel.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        if (BufferedImage.class != objectClass) {
            throw new UnsupportedOperationException(objectClass + " not supported in JImageChooserPropertiesEditor");
        }
        this.setImage((BufferedImage)renderedObject);
    }

    public Object getValue(Class objectClass) {
        if (BufferedImage.class == objectClass) {
            return this.storedImage;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JImageChooserPropertiesEditor");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.imageLabel.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
    }
}

