/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.propertiespanel.undecided.UndecidedBigDecimal;
import exenne.components.propertiespanel.undecided.UndecidedInteger;
import exenne.components.textfield.fixedwidth.JFixedWidthTextField;
import exenne.components.utils.NumberUtils;
import exenne.components.utils.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldPropertiesEditor
extends JPanel
implements IPropertiesEditor,
DocumentListener {
    private JTextField textfield;
    private JLabel endingLabel;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JTextFieldPropertiesEditor(int width) {
        this(width, "");
    }

    public JTextFieldPropertiesEditor(int width, String endingText, int labelWidth) {
        this.textfield = new JFixedWidthTextField(width);
        this.endingLabel = new JLabel(endingText);
        this.endingLabel.setPreferredSize(new Dimension(labelWidth, 0));
        this.initialize();
    }

    public JTextFieldPropertiesEditor(int width, String endingText) {
        this.textfield = new JFixedWidthTextField(width);
        this.endingLabel = new JLabel(endingText);
        this.initialize();
    }

    public JTextFieldPropertiesEditor(String endingText, int labelWidth) {
        this.textfield = new JFixedWidthTextField();
        this.endingLabel = new JLabel(endingText);
        this.endingLabel.setPreferredSize(new Dimension(labelWidth, 0));
        this.initialize();
    }

    public JTextFieldPropertiesEditor(String endingText) {
        this.textfield = new JFixedWidthTextField();
        this.endingLabel = new JLabel(endingText);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.textfield, "Center");
        this.add((Component)this.endingLabel, "East");
        this.endingLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.textfield.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JTextFieldPropertiesEditor.this.textfield.selectAll();
            }
        });
        this.editorChangeListeners = new Vector();
        this.textfield.getDocument().addDocumentListener(this);
    }

    public String getEndingText() {
        return this.endingLabel.getText();
    }

    public void setEndingText(String endingText) {
        this.endingLabel.setText(endingText);
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.textfield;
    }

    public void setEditorName(String name) {
        this.setName(name);
        this.textfield.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        if (String.class == objectClass) {
            String auxString = (String)renderedObject;
            this.textfield.setText(auxString);
            this.textfield.setHorizontalAlignment(2);
        } else if (Integer.class == objectClass) {
            Integer auxInteger = (Integer)renderedObject;
            this.textfield.setText(auxInteger.toString());
            this.textfield.setHorizontalAlignment(4);
        } else if (BigDecimal.class == objectClass) {
            BigDecimal auxBigDecimal = (BigDecimal)renderedObject;
            auxBigDecimal = auxBigDecimal.stripTrailingZeros();
            this.textfield.setText(auxBigDecimal.toPlainString());
            this.textfield.setHorizontalAlignment(4);
        } else if (UndecidedBigDecimal.class == objectClass) {
            UndecidedBigDecimal auxUndecidedBigDecimal = (UndecidedBigDecimal)renderedObject;
            this.textfield.setText(auxUndecidedBigDecimal.toString());
            this.textfield.setHorizontalAlignment(4);
        } else if (UndecidedInteger.class == objectClass) {
            UndecidedInteger auxUndecidedInteger = (UndecidedInteger)renderedObject;
            this.textfield.setText(auxUndecidedInteger.toString());
            this.textfield.setHorizontalAlignment(4);
        } else {
            throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
        }
    }

    public Object getValue(Class objectClass) {
        if (String.class == objectClass) {
            String auxString = StringUtilities.removeWindowsCarriageReturn(this.textfield.getText());
            return auxString;
        }
        if (Integer.class == objectClass) {
            String auxString = this.textfield.getText();
            Integer auxInteger = NumberUtils.toInteger(auxString);
            if (auxInteger == null) {
                auxInteger = 0;
            }
            return auxInteger;
        }
        if (BigDecimal.class == objectClass) {
            String auxString = this.textfield.getText();
            BigDecimal auxBigDecimal = NumberUtils.toBigDecimal(auxString);
            if (auxBigDecimal == null) {
                auxBigDecimal = BigDecimal.ZERO;
            }
            return auxBigDecimal;
        }
        if (UndecidedBigDecimal.class == objectClass) {
            String auxString = this.textfield.getText();
            UndecidedBigDecimal auxUndecidedBigDecimal = new UndecidedBigDecimal(auxString);
            return auxUndecidedBigDecimal;
        }
        if (UndecidedBigDecimal.class == objectClass) {
            String auxString = this.textfield.getText();
            UndecidedInteger auxUndecidedInteger = new UndecidedInteger(auxString);
            return auxUndecidedInteger;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textfield.setEnabled(enabled);
    }

    public void insertUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    public void changedUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    private void notifyAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

