/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.sidebar;

import exenne.components.sidebar.IResizableBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class JResizableBorder
implements IResizableBorder {
    private int dist = 6;
    private int distS;
    private int distN;
    private int distW;
    private int distE;

    public JResizableBorder(int dist, int type) {
        this.dist = dist;
        if ((type & 1) > 0) {
            this.distN = dist;
        }
        if ((type & 2) > 0) {
            this.distS = dist;
        }
        if ((type & 4) > 0) {
            this.distE = dist;
        }
        if ((type & 8) > 0) {
            this.distW = dist;
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.distN, this.distW, this.distS, this.distE);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        g.setColor(Color.black);
        if (this.distW > 0) {
            g.drawLine(x + this.dist / 2, y + 2 * this.dist, x + this.dist / 2, y + h - 2 * this.dist);
        }
        if (this.distE > 0) {
            g.drawLine(x + w - this.dist / 2, y + 2 * this.dist, x + w - this.dist / 2, y + h - 2 * this.dist);
        }
        if (this.distN > 0) {
            g.drawLine(x + 2 * this.dist, y + this.dist / 2, x + w - 2 * this.dist, y + this.dist / 2);
        }
        if (this.distS > 0) {
            g.drawLine(x + 2 * this.dist, y + h - this.dist / 2, x + w - 2 * this.dist, y + h - this.dist / 2);
        }
    }

    public int getResizeCursor(MouseEvent me) {
        Component comp = me.getComponent();
        Point point = me.getPoint();
        int w = comp.getWidth();
        int h = comp.getHeight();
        Rectangle rect = new Rectangle(0, this.distN, this.distW, h - this.distN - this.distS);
        if (rect.contains(point)) {
            return 10;
        }
        rect = new Rectangle(w - this.distE, this.distN, this.distE, h - this.distN - this.distS);
        if (rect.contains(point)) {
            return 11;
        }
        rect = new Rectangle(this.distW, 0, w - this.distW - this.distE, this.distN);
        if (rect.contains(point)) {
            return 8;
        }
        rect = new Rectangle(this.distW, h - this.distS, w - this.distW - this.distE, this.distS);
        if (rect.contains(point)) {
            return 9;
        }
        return 0;
    }
}

