/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.swingworkers.progressworker;

import exenne.components.swingworkers.progressworker.ProgressInfoManager;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProgressCallable<V>
implements Callable<V>,
ProgressInfoManager {
    private static final int INF_LIMIT = 0;
    private static final int SUP_LIMIT = 100;
    private int inferiorLimit = 0;
    private int superiorLimit = 100;
    private ProgressInfoManager progressInfoManager;

    public void setProgressInfoManager(ProgressInfoManager progressInfoManager) {
        this.progressInfoManager = progressInfoManager;
    }

    public void setInferiorLimit(int inferiorLimit) {
        this.inferiorLimit = inferiorLimit;
    }

    public void setSuperiorLimit(int superiorLimit) {
        this.superiorLimit = superiorLimit;
    }

    public void setProgressRange(int inferiorLimit, int superiorLimit) {
        this.setInferiorLimit(inferiorLimit);
        this.setSuperiorLimit(superiorLimit);
    }

    @Override
    public void setProgressInfo(String info) {
        if (this.progressInfoManager != null) {
            this.progressInfoManager.setProgressInfo(info);
        }
    }

    @Override
    public void setProgressValue(int value) {
        if (this.progressInfoManager != null) {
            int var1 = this.inferiorLimit * (100 - value);
            int var2 = this.superiorLimit * value;
            int newValue = (var1 + var2) / 100;
            this.progressInfoManager.setProgressValue(newValue);
        }
    }

    @Override
    public void addErrorMessage(String error) {
        if (this.progressInfoManager != null) {
            this.progressInfoManager.addErrorMessage(error);
        }
    }
}

