/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.cellrenderers;

import exenne.components.treetable.cellrenderers.AbstractTreetableCellRenderer;
import exenne.components.treetable.cellrenderers.TreetableTooltipBorder;
import exenne.components.utils.GraphicRenderingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;

public class DefaultTreetableCellRenderer
extends AbstractTreetableCellRenderer {
    private Border tooltipBorder = new TreetableTooltipBorder();

    public void setBorder(Border b) {
        if (b == this.tooltipBorder) {
            super.setBorder(b);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(this.tooltipBorder, b));
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return this;
    }

    public void paint(Graphics g) {
        Color colorItem;
        int i;
        Graphics2D g2d = (Graphics2D)g;
        int startX = 0;
        int startY = 0;
        int localWidth = 0;
        int localHeight = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int arcW = 5;
        int arcH = 5;
        int iconWidth = this.getNestingWidth();
        int lineWidth = 2;
        int focusMarkerSize = 4;
        g2d.setStroke(new BasicStroke(lineWidth));
        boolean shouldPaint = true;
        Color actualBgColor = this.getBackground();
        Color actualFgColor = this.getForeground();
        Color prefferedBgColor = this.getPrefferedBackground();
        Color prefferedFgColor = this.getPrefferedForeground();
        g2d.setColor(actualBgColor);
        g2d.fillRect(0, 0, width, height);
        this.setBackground(null);
        if (this.isCellEditable()) {
            Color colorRight;
            Color colorLeft;
            boolean isLeftAligned;
            boolean bl = isLeftAligned = this.getHorizontalAlignment() == 2 || this.getHorizontalAlignment() == 10;
            if (this.isSelected()) {
                colorLeft = g2d.getColor();
                colorRight = GraphicRenderingUtils.lightenColor(colorLeft, 20);
            } else {
                colorLeft = g2d.getColor();
                colorRight = Color.WHITE;
            }
            GraphicRenderingUtils.drawEditableBackground(g2d, colorLeft, colorRight, width, height, iconWidth, isLeftAligned);
            this.setBackground(null);
        }
        if (this.isFirstColumn()) {
            boolean isLast = false;
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, (this.getNestingDepth() - 1) * iconWidth, height);
            for (i = 1; i < this.getNestingDepth(); ++i) {
                colorItem = this.getHashtableParentColor().get(i);
                if (!this.isExpanded()) {
                    isLast = this.getHashtableIsLast().get(i);
                }
                if (colorItem == null) continue;
                startX = i * iconWidth;
                startY = 0;
                g2d.setColor(colorItem);
                g2d.drawLine(startX, startY, startX, startY + height);
                if (!isLast) continue;
                g2d.drawLine(startX, startY + height - lineWidth + 1, width, startY + height - lineWidth + 1);
            }
        } else if (this.isLastColumn()) {
            boolean isLast = false;
            for (i = this.getNestingDepth() - 1; i > 0; --i) {
                colorItem = this.getHashtableParentColor().get(i);
                if (!this.isExpanded()) {
                    isLast = this.getHashtableIsLast().get(i);
                }
                if (colorItem == null) continue;
                startX = width - 3;
                startY = 0;
                g2d.setColor(Color.WHITE);
                g2d.fillRect(startX, startY, width, height);
                g2d.setColor(colorItem);
                g2d.drawLine(startX, startY, startX, startY + height);
                if (!isLast) break;
                g2d.drawLine(0, startY + height - lineWidth + 1, startX, startY + height - lineWidth + 1);
                break;
            }
        } else {
            boolean isLast = false;
            for (i = 1; i < this.getNestingDepth(); ++i) {
                colorItem = this.getHashtableParentColor().get(i);
                if (!this.isExpanded()) {
                    isLast = this.getHashtableIsLast().get(i);
                }
                if (colorItem == null) continue;
                startX = 0;
                startY = 0;
                g2d.setColor(colorItem);
                if (!isLast) continue;
                g2d.drawLine(startX, startY + height - lineWidth + 1, width, startY + height - lineWidth + 1);
            }
        }
        if (this.isGrouping()) {
            if (this.isFirstColumn()) {
                g.setColor(prefferedBgColor);
                startX = this.getNestingDepth() * iconWidth - lineWidth + 1;
                startY = 0;
                localWidth = width - startX - 3;
                localHeight = !this.isExpanded() ? height - startY - 1 : height + 100;
                g2d.fill(new RoundRectangle2D.Double(startX, startY, localWidth, localHeight, arcW, arcH));
                if (this.isExpanded()) {
                    g2d.drawLine(startX + lineWidth, height - 1, width + startX, height - 1);
                }
                this.setBackground(null);
                this.setForeground(prefferedFgColor);
            } else if (this.isCellImportant()) {
                g.setColor(prefferedBgColor);
                startY = 0;
                if (this.isLeftCellImportant() && this.isRightCellImportant()) {
                    startX = -arcW;
                    localWidth = width - 2 * startX;
                } else if (this.isLeftCellImportant()) {
                    startX = -arcW;
                    localWidth = width - startX - 2;
                } else if (this.isRightCellImportant()) {
                    startX = 2;
                    localWidth = width;
                } else {
                    startX = 2;
                    localWidth = width - startX - 2;
                }
                localHeight = this.isExpanded() ? height + 100 : height - startY - 1;
                g2d.fill(new RoundRectangle2D.Double(startX, startY, localWidth, localHeight, arcW, arcH));
                if (this.isExpanded()) {
                    if (this.isLastColumn()) {
                        g2d.drawLine(0, height - 1, width - startX - 3, height - 1);
                    } else {
                        g2d.drawLine(0, height - 1, width, height - 1);
                    }
                }
                this.setBackground(null);
                this.setForeground(prefferedFgColor);
            } else {
                g.setColor(prefferedBgColor);
                startX = 0;
                if (this.isExpanded()) {
                    if (this.isLastColumn()) {
                        g2d.drawLine(0, height - 1, width - startX - 3, height - 1);
                    } else {
                        g2d.drawLine(0, height - 1, width, height - 1);
                    }
                }
            }
        }
        if (this.hasSomeFocus()) {
            g2d.setColor(actualFgColor);
            startX = 0;
            startY = 0;
            g2d.drawLine(startX, startY, startX, focusMarkerSize);
            g2d.drawLine(startX, startY, focusMarkerSize, startY);
            startX = 0;
            startY = height;
            g2d.drawLine(startX, startY, startX, startY - focusMarkerSize);
            g2d.drawLine(startX, startY, focusMarkerSize, startY);
            startX = width;
            startY = height;
            g2d.drawLine(startX, startY, startX, startY - focusMarkerSize);
            g2d.drawLine(startX, startY, startX - focusMarkerSize, startY);
            startX = width;
            startY = 0;
            g2d.drawLine(startX, startY, startX, focusMarkerSize);
            g2d.drawLine(startX, startY, startX - focusMarkerSize, startY);
        }
        if (shouldPaint) {
            super.paint(g);
        }
    }
}

