/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import exenne.components.treetable.undosupport.RemoveNodeFromParentStandardUndoableEdit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class InsertNodeToParentStandardUndoableEdit
extends AbstractUndoableEdit {
    private Treetable treetable;
    private DefaultMutableTreeNode newNode;
    private DefaultMutableTreeNode parentNode;
    private int position;
    private UndoableEdit removeAction = null;

    public InsertNodeToParentStandardUndoableEdit(Treetable treetable, DefaultMutableTreeNode newNode, DefaultMutableTreeNode parentNode, int position) {
        this.treetable = treetable;
        this.newNode = newNode;
        this.parentNode = parentNode;
        this.position = position;
    }

    public void execute() {
        DefaultTreeModel model = (DefaultTreeModel)this.treetable.getTreetableModel().getTreeModel();
        model.insertNodeInto(this.newNode, this.parentNode, this.position);
        this.treetable.expandNode(this.parentNode);
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this.removeAction == null) {
            RemoveNodeFromParentStandardUndoableEdit localRemoveAction = new RemoveNodeFromParentStandardUndoableEdit(this.treetable, this.newNode);
            localRemoveAction.execute();
            this.removeAction = localRemoveAction;
        } else {
            this.removeAction.redo();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.removeAction.undo();
    }
}

