/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharsetValidator
implements Validator<String> {
    @Override
    public boolean validate(Problems problems, String compName, String model) {
        IllegalArgumentException e = null;
        try {
            Charset.forName(model);
        }
        catch (IllegalCharsetNameException badName) {
            problems.add(NbBundle.getMessage(CharsetValidator.class, "ILLEGAL_CHARSET_NAME", compName, model));
            e = badName;
        }
        catch (UnsupportedCharsetException unsup) {
            problems.add(NbBundle.getMessage(CharsetValidator.class, "UNSUPPORTED_CHARSET_NAME", compName, model));
            e = unsup;
        }
        return e == null;
    }
}

