/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowerOrEqualValueValidator
implements Validator<String> {
    private Number max;

    public LowerOrEqualValueValidator(Number max) {
        this.max = max;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            double d = Double.parseDouble(model);
            double maxx = this.max.doubleValue();
            if (d > maxx) {
                String problem = NbBundle.getMessage(LowerOrEqualValueValidator.class, "LOWER_OR_EQUAL_VALUE", compName, model, this.max);
                problems.add(problem);
                return false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return true;
    }
}

