/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.EmailAddressValidator;
import org.netbeans.validation.api.builtin.ValidHostNameOrIPValidator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlValidator
implements Validator<String> {
    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            URL url = new URL(model);
            String host = url.getHost();
            if (!"".equals(host)) {
                return new ValidHostNameOrIPValidator(true).validate(problems, compName, host);
            }
            String protocol = url.getProtocol();
            if ("mailto".equals(protocol)) {
                String emailAddress = url.toString().substring("mailto:".length());
                emailAddress = emailAddress == null ? "" : emailAddress;
                return new EmailAddressValidator().validate(problems, compName, emailAddress);
            }
            return true;
        }
        catch (MalformedURLException e) {
            String problem = NbBundle.getMessage(UrlValidator.class, "URL_NOT_VALID", model);
            problems.add(problem);
            return false;
        }
    }
}

