/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveNodeFromParentStandardUndoableEdit
extends AbstractUndoableEdit {
    private Treetable treetable;
    private DefaultMutableTreeNode deletedNode;
    private DefaultMutableTreeNode parentNode;
    private int position;
    private boolean isDeletedNodeExpanded;

    public RemoveNodeFromParentStandardUndoableEdit(Treetable treetable, DefaultMutableTreeNode deletedNode) {
        this.treetable = treetable;
        this.deletedNode = deletedNode;
    }

    public void execute() {
        DefaultTreeModel model = (DefaultTreeModel)this.treetable.getOutlineModel().getTreeModel();
        this.parentNode = (DefaultMutableTreeNode)this.deletedNode.getParent();
        this.isDeletedNodeExpanded = this.treetable.isNodeExpanded(this.deletedNode);
        if (this.isDeletedNodeExpanded) {
            this.treetable.collapseNode(this.deletedNode);
        }
        this.treetable.expandNode(this.parentNode);
        this.position = model.getIndexOfChild(this.parentNode, this.deletedNode);
        model.removeNodeFromParent(this.deletedNode);
    }

    public void undo() throws CannotUndoException {
        super.undo();
        DefaultTreeModel model = (DefaultTreeModel)this.treetable.getOutlineModel().getTreeModel();
        model.insertNodeInto(this.deletedNode, this.parentNode, this.position);
        this.treetable.expandNode(this.parentNode);
        if (this.isDeletedNodeExpanded) {
            this.treetable.expandNode(this.deletedNode);
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.execute();
    }
}

