/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.object;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jca.cci.core.RecordCreator;
import org.springframework.jca.cci.core.RecordExtractor;
import org.springframework.jca.cci.object.EisOperation;

public abstract class MappingRecordOperation
extends EisOperation {
    public MappingRecordOperation() {
    }

    public MappingRecordOperation(ConnectionFactory connectionFactory, InteractionSpec interactionSpec) {
        this.getCciTemplate().setConnectionFactory(connectionFactory);
        this.setInteractionSpec(interactionSpec);
    }

    public void setOutputRecordCreator(RecordCreator creator) {
        this.getCciTemplate().setOutputRecordCreator(creator);
    }

    public Object execute(Object inputObject) throws DataAccessException {
        return this.getCciTemplate().execute(this.getInteractionSpec(), new RecordCreatorImpl(inputObject), (RecordExtractor)new RecordExtractorImpl());
    }

    protected abstract Record createInputRecord(RecordFactory var1, Object var2) throws ResourceException, DataAccessException;

    protected abstract Object extractOutputData(Record var1) throws ResourceException, SQLException, DataAccessException;

    protected class RecordCreatorImpl
    implements RecordCreator {
        private final Object inputObject;

        public RecordCreatorImpl(Object inObject) {
            this.inputObject = inObject;
        }

        public Record createRecord(RecordFactory recordFactory) throws ResourceException, DataAccessException {
            return MappingRecordOperation.this.createInputRecord(recordFactory, this.inputObject);
        }
    }

    protected class RecordExtractorImpl
    implements RecordExtractor {
        protected RecordExtractorImpl() {
        }

        public Object extractData(Record record) throws ResourceException, SQLException, DataAccessException {
            return MappingRecordOperation.this.extractOutputData(record);
        }
    }
}

