/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.celleditors;

import exenne.components.treetable.SelfManagedComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author iulian
 */
/**
 * MySwing: Advanced Swing Utilites
 * Copyright (C) 2005  Santhosh Kumar T
 * <p/>
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * @author Santhosh Kumar T
 * @email santhosh@fiorano.com
 */
public class MultiLineTableCellEditorV2 extends AbstractCellEditor implements TableCellEditor, ActionListener{
    JTextArea textArea = new ResizableTextArea();

    public MultiLineTableCellEditorV2(){
        textArea.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        textArea.registerKeyboardAction(this
                , KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, KeyEvent.CTRL_MASK)
                , JComponent.WHEN_FOCUSED);
    }

    public Object getCellEditorValue(){
        return textArea.getText();
    }

    /*--------------------------------[ clickCountToStart ]----------------------------------*/

    protected int clickCountToStart = 2;

    public int getClickCountToStart(){
        return clickCountToStart;
    }

    public void setClickCountToStart(int clickCountToStart){
        this.clickCountToStart = clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject e){
        return !(e instanceof MouseEvent)
                || ((MouseEvent)e).getClickCount()>=clickCountToStart;
    }

    /*--------------------------------[ ActionListener ]------------------------*/

    public void actionPerformed(ActionEvent ae){
        stopCellEditing();
    }

    /*---------------------------[ TableCellEditor ]------------------------*/

    public Component getTableCellEditorComponent(JTable table, Object value
            , boolean isSelected, int row, int column){
        String text = value!=null ? value.toString() : "";
        textArea.setText(text);
        return textArea;
    }


    /*-------------------------------------------------[ ResizableTextArea ]---------------------------------------------------*/
    public static final String UPDATE_BOUNDS = "UpdateBounds";
    
    class ResizableTextArea extends JTextArea implements SelfManagedComponent {

        @Override
        public void setBounds(int x, int y, int width, int height){
            if(Boolean.TRUE.equals(getClientProperty(UPDATE_BOUNDS)))
                super.setBounds(x, y, width, height);
        }

        @Override
        public void addNotify(){
            super.addNotify();
            getDocument().addDocumentListener(listener);
        }

        @Override
        public void removeNotify(){
            getDocument().removeDocumentListener(listener);
            super.removeNotify();
        }

        DocumentListener listener = new DocumentListener(){
            public void insertUpdate(DocumentEvent e){
                updateBounds();
            }

            public void removeUpdate(DocumentEvent e){
                updateBounds();
            }

            public void changedUpdate(DocumentEvent e){
                updateBounds();
            }
        };

        /**
         * Called by the table when opening cell editor
         * @param cellRect
         */
        public void updateBounds(Rectangle cellRect) {
            Dimension prefSize = getPreferredSize();
            putClientProperty(UPDATE_BOUNDS, Boolean.TRUE);
            setBounds(cellRect.x, cellRect.y
                    , Math.max(cellRect.width, prefSize.width)
                    , Math.max(cellRect.height, prefSize.height));
            putClientProperty(UPDATE_BOUNDS, Boolean.FALSE);
            validate();
        }

        /**
         * called by self
         */
        private void updateBounds(){
            if(getParent() instanceof JTable){
                JTable table = (JTable)getParent();
                if(table.isEditing()){
                    Rectangle cellRect = table.getCellRect(table.getEditingRow(), table.getEditingColumn(), false);
                    Dimension prefSize = getPreferredSize();
                    putClientProperty(UPDATE_BOUNDS, Boolean.TRUE);
                    setBounds(getX(), getY(), Math.max(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
                    putClientProperty(UPDATE_BOUNDS, Boolean.FALSE);
                    validate();
                }
            }
        }
    }
}