
package exenne.components.jdatepicker;

import java.awt.event.ActionListener;
import java.util.Properties;

/**
 * This interface is implemented by all components which represent a date by day
 * granularity. T will be one of the following org.joda.time.DateMidnight,
 * java.util.Date or java.util.Calendar.
 * 
 * Since the first version of JDatePicker generics was added to Java and
 * JodaTime emerged as a important date handling library in the Java community.
 * 
 * Created 16 April 2010
 * Updated 18 April 2010
 * 
 * @author Juan Heyns
 */
public interface JDateComponent {
	
	/**
	 * Returns the value of the currently represented date in the component.
	 * Depending on the version of the library used this type will one of the
	 * following:
	 * - java.util.Calendar
	 * - org.joda.time.DateMidnight
	 * - java.util.Date
	 * 
	 * @return
	 */
	public DateModel<?> getModel();

	/**
	 * Adds an ActionListener. The actionListener is notified when a user clicks
	 * on a date. Deliberately selecting a date will trigger this event, not
	 * scrolling which fires a ChangeEvent for ChangeListeners.
	 * 
	 * @param actionListener
	 */
	public void addActionListener(ActionListener actionListener);

	/**
	 * Removes the ActionListener. The actionListener is notified when a user
	 * clicks on a date.
	 * 
	 * @param arg
	 */
	public void removeActionListener(ActionListener actionListener);

	/**
	 * Gets the currently set internationalised strings of the component.
	 * 
	 * @return
	 */
	public Properties getI18nStrings();
	
	/**
	 * Sets internationalised the strings of the component.
	 * 
	 * @param strings
	 */
	public void setI18nStrings(Properties i18nStrings);

}
