/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.labellines;

import exenne.components.utils.ComponentsUtils;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Clasa reprezinta o pereche cheie - valoare afisate ca JLabel-uri pe o singura linie
 * @author iulian
 */
public class JDescriptionPairLine extends JPanel {
    private static final int FIELD_SPACER = 5;
    
    //Structura panoului
    private JLabel keyLabel;
    private JLabel descriptionLabel;
    
    /**
     * Construiesc o linie de pereche cheie valoare
     */
    public JDescriptionPairLine(String key, String value) {
        this(key, value, true);
    }
    
    /**
     * Construiesc o linie de pereche cheie valoare
     */
    public JDescriptionPairLine(String key, String value, boolean isKeyBold) {
        super();
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        
            keyLabel = new JLabel(key);
        if (isKeyBold)
            ComponentsUtils.setFontBold(keyLabel);
        this.add(keyLabel);
        this.add(Box.createHorizontalStrut(FIELD_SPACER));
            descriptionLabel = new JLabel(value);
        this.add(descriptionLabel);
        this.add(Box.createHorizontalGlue());
    }
}
