/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.valueshields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 *
 * @author iulian
 */
public class JSimpleValueShield extends JPanel {
    public static final Color DEFAULT_BG = new Color(205,205,255);
    
    /**
     * Contructor secundar
     */
    public JSimpleValueShield(JLabel textSus, JLabel textJos, int boxWidth) {
        this(textSus, textJos, boxWidth, DEFAULT_BG);
    }
    
    /**
     * Contructor principal. Creeaza un shield pentru afisare unei valori
     * @param textSus
     * @param textJos
     * @param boxWidth
     * @param bgColor 
     */
    public JSimpleValueShield(JLabel textSus, JLabel textJos, int boxWidth, Color bgColor) {
        super();
        
        this.setLayout(new GridLayout(2, 1));
        this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            textSus.setBackground(bgColor);
            textSus.setOpaque(true);
            textSus.setPreferredSize(new Dimension(boxWidth, 0));
            textSus.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add(textSus);
        JPanel spanner = new JPanel();
            spanner.setLayout(new BoxLayout(spanner, BoxLayout.X_AXIS));
            spanner.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
            spanner.add(Box.createHorizontalGlue());
                textJos.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            spanner.add(textJos);
        this.add(spanner);
    }
}
