/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.propertiespanel;

import javax.swing.JComponent;

/**
 * Interfata ce defineste un editor de proprietati
 * @author iulian
 */
public interface IPropertiesEditor {

    /**
     * Obtin containerul global al editorului
     * @return
     */
    public JComponent getContainerComponent();

    /**
     * Obtine componenta care realizeaza editarea propriu-zisa
     * @return
     */
    public JComponent getEditorComponent();

    /**
     * Seteaza numele pentru aceasta componenta
     * @param name
     */
    public void setEditorName(String name);

    /**
     * Seteaza valoarea editata
     * @param objectClass
     * @param renderedObject
     */
    public void setValue(Class objectClass, Object renderedObject);

    /**
     * Obtine valoarea editata facuta cast la clasa corespunzatoare
     * @param objectClass
     * @return
     */
    public Object getValue(Class objectClass);

    /**
     * Adaug un ascultator pentru schimbare valori
     * @param listener
     */
    public void addEditorChangeListener(IEditorChangeListener listener);

    /**
     * Deinregistrez un ascultator pentru schimbare valori
     * @param listener
     */
    public void removeEditorChangeListener(IEditorChangeListener listener);
}
