/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.propertiespanel.editors;

import exenne.components.jdatepicker.impl.JDatePanelImpl;
import exenne.components.jdatepicker.impl.JDatePickerImpl;
import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

/**
 *
 * @author iulian
 */
public class JDatePickerPropertiesEditor extends JDatePickerImpl 
        implements IPropertiesEditor, ActionListener {
    private Vector<IEditorChangeListener> editorChangeListeners;

    /**
     * Construiesc un date picker
     */
    public JDatePickerPropertiesEditor() {
        super(new JDatePanelImpl(null), null);
        initialize();
    }

    /**
     * Functie de initializare
     */
    private void initialize() {
        editorChangeListeners = new Vector<IEditorChangeListener>();
        this.addActionListener(this);
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Se implementeaza interfata IPropertiesEditor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin containerul global al editorului
     * @return
     */
    public JComponent getContainerComponent() {
        return this;
    }

    /**
     * Obtine componenta care realizeaza editarea propriu-zisa
     * @return
     */
    public JComponent getEditorComponent() {
        return this.getJFormattedTextField();
    }

    /**
     * Seteaza numele componentei
     * @param name
     */
    @Override
    public void setEditorName(String name) {
        this.getJFormattedTextField().setName(name);
    }

    /**
    * Se seteaza valoarea ce se editeaza
    * @param objectClass
    * @param renderedObject
    */
    public void setValue(Class objectClass, Object renderedObject) {
        Date auxDate;

        //Setez obiectul in textfield
        if (Date.class == objectClass) {
            auxDate = (Date) renderedObject;
            this.getModel().setDate(
                    auxDate.getYear()+1900, auxDate.getMonth(), auxDate.getDate());
            this.getModel().setSelected(true);
        } else
            throw new UnsupportedOperationException(objectClass+" not supported in JTextField");
    }

    /**
     * Se obtione valoarea din textfield cu cast la clasa specificata
     * @param objectClass
     * @return
     */
    public Object getValue(Class objectClass) {
        Date auxDate;

        //Obtin obiectul din textfield
        if (Date.class == objectClass) {
            //Setez si data euro
            GregorianCalendar cal;
            cal = (GregorianCalendar)this.getJFormattedTextField().getValue();
            auxDate = cal.getTime();

            Date strippedDate = new Date(0,0,0);
            strippedDate.setYear(auxDate.getYear());
            strippedDate.setMonth(auxDate.getMonth());
            strippedDate.setDate(auxDate.getDate());
            strippedDate.setHours(0);
            strippedDate.setMinutes(0);
            strippedDate.setSeconds(0);

            return strippedDate;
        } else
            throw new UnsupportedOperationException(objectClass+" not supported in JDatePicker");
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Managementul actiunilor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Aici primesc evenimente de la checkbox
     * @param e
     */
    public void actionPerformed(ActionEvent e) {
        Iterator<IEditorChangeListener> iterator = editorChangeListeners.iterator();
        while (iterator.hasNext()) {
            IEditorChangeListener iEditorChangeListener = iterator.next();
            iEditorChangeListener.fireValueChanged();
        }
    }

    /**
     * Adaug un ascultator pentru schimbare valori
     * @param listener
     */
    public void addEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.add(listener);
    }

    /**
     * Deinregistrez un ascultator pentru schimbare valori
     * @param listener
     */
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.remove(listener);
    }
}
