/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.sidebar;

import java.awt.*;

/**
 * Clasa ce defineste umbra de resize al unei ferestre. Pentru a modifica
 * felul cum este desenata aceasta, se modifica decat aici
 * @author iulian
 */
public class JResizeMarker {
    //Constante pentru tipul urmei
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    //Variabile ajutatoare
    private int thick = 3;
    private int x,y;
    private int height,width;

    /**
     * Obiectul se construieste cu variabilele containerului in care se deseneaza
     * @param x pozitia pe axa X
     * @param y pozitia pe axa Y
     * @param length lungimea markerului
     * @param orientation Orientare (H sau V)
     */
    public JResizeMarker(int x, int y, int length, int orientation) {
        this.x = x;
        this.y = y;

        switch (orientation) {
        case HORIZONTAL:
            this.height = thick;
            this.width = length;
            break;
        case VERTICAL:
            this.height = length;
            this.width = thick;
            break;
        }
    }

    /**
     * In aceasta metoda pot sa desenez markerul in ce mod vreu eu
     * @param g Contxetul grafic in care se deseneaza
     */
    public void paint(Graphics g){
        //In cazul asta il desenez ca un dreptunghi umplut
        g.setColor(Color.GREEN);
        g.fillRect(x, y, width, height);
    }
}
